/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateDnsGtmMonitorRequest
extends Request {
    @Query
    @NameInMap(value="EvaluationCount")
    @Validation(maximum=3.0, minimum=1.0)
    private Integer evaluationCount;
    @Query
    @NameInMap(value="Interval")
    @Validation(maximum=60.0, minimum=15.0)
    private Integer interval;
    @Query
    @NameInMap(value="IspCityNode")
    @Validation(required=true)
    private List<IspCityNode> ispCityNode;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="MonitorConfigId")
    @Validation(required=true)
    private String monitorConfigId;
    @Query
    @NameInMap(value="MonitorExtendInfo")
    @Validation(required=true)
    private String monitorExtendInfo;
    @Query
    @NameInMap(value="ProtocolType")
    @Validation(required=true)
    private String protocolType;
    @Query
    @NameInMap(value="Timeout")
    @Validation(maximum=10000.0, minimum=1000.0)
    private Integer timeout;

    private UpdateDnsGtmMonitorRequest(Builder builder) {
        super((Request.Builder)builder);
        this.evaluationCount = builder.evaluationCount;
        this.interval = builder.interval;
        this.ispCityNode = builder.ispCityNode;
        this.lang = builder.lang;
        this.monitorConfigId = builder.monitorConfigId;
        this.monitorExtendInfo = builder.monitorExtendInfo;
        this.protocolType = builder.protocolType;
        this.timeout = builder.timeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateDnsGtmMonitorRequest create() {
        return UpdateDnsGtmMonitorRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getEvaluationCount() {
        return this.evaluationCount;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public List<IspCityNode> getIspCityNode() {
        return this.ispCityNode;
    }

    public String getLang() {
        return this.lang;
    }

    public String getMonitorConfigId() {
        return this.monitorConfigId;
    }

    public String getMonitorExtendInfo() {
        return this.monitorExtendInfo;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public static class IspCityNode
    extends TeaModel {
        @NameInMap(value="CityCode")
        private String cityCode;
        @NameInMap(value="IspCode")
        private String ispCode;

        private IspCityNode(Builder builder) {
            this.cityCode = builder.cityCode;
            this.ispCode = builder.ispCode;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static IspCityNode create() {
            return IspCityNode.builder().build();
        }

        public String getCityCode() {
            return this.cityCode;
        }

        public String getIspCode() {
            return this.ispCode;
        }

        public static final class Builder {
            private String cityCode;
            private String ispCode;

            private Builder() {
            }

            private Builder(IspCityNode model) {
                this.cityCode = model.cityCode;
                this.ispCode = model.ispCode;
            }

            public Builder cityCode(String cityCode) {
                this.cityCode = cityCode;
                return this;
            }

            public Builder ispCode(String ispCode) {
                this.ispCode = ispCode;
                return this;
            }

            public IspCityNode build() {
                return new IspCityNode(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateDnsGtmMonitorRequest, Builder> {
        private Integer evaluationCount;
        private Integer interval;
        private List<IspCityNode> ispCityNode;
        private String lang;
        private String monitorConfigId;
        private String monitorExtendInfo;
        private String protocolType;
        private Integer timeout;

        private Builder() {
        }

        private Builder(UpdateDnsGtmMonitorRequest request) {
            super((Request)request);
            this.evaluationCount = request.evaluationCount;
            this.interval = request.interval;
            this.ispCityNode = request.ispCityNode;
            this.lang = request.lang;
            this.monitorConfigId = request.monitorConfigId;
            this.monitorExtendInfo = request.monitorExtendInfo;
            this.protocolType = request.protocolType;
            this.timeout = request.timeout;
        }

        public Builder evaluationCount(Integer evaluationCount) {
            this.putQueryParameter("EvaluationCount", evaluationCount);
            this.evaluationCount = evaluationCount;
            return this;
        }

        public Builder interval(Integer interval) {
            this.putQueryParameter("Interval", interval);
            this.interval = interval;
            return this;
        }

        public Builder ispCityNode(List<IspCityNode> ispCityNode) {
            this.putQueryParameter("IspCityNode", ispCityNode);
            this.ispCityNode = ispCityNode;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder monitorConfigId(String monitorConfigId) {
            this.putQueryParameter("MonitorConfigId", monitorConfigId);
            this.monitorConfigId = monitorConfigId;
            return this;
        }

        public Builder monitorExtendInfo(String monitorExtendInfo) {
            this.putQueryParameter("MonitorExtendInfo", monitorExtendInfo);
            this.monitorExtendInfo = monitorExtendInfo;
            return this;
        }

        public Builder protocolType(String protocolType) {
            this.putQueryParameter("ProtocolType", protocolType);
            this.protocolType = protocolType;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.putQueryParameter("Timeout", timeout);
            this.timeout = timeout;
            return this;
        }

        public UpdateDnsGtmMonitorRequest build() {
            return new UpdateDnsGtmMonitorRequest(this);
        }
    }
}

