/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateGtmAddressPoolRequest
extends Request {
    @Query
    @NameInMap(value="Addr")
    @Validation(required=true)
    private List<Addr> addr;
    @Query
    @NameInMap(value="AddrPoolId")
    @Validation(required=true)
    private String addrPoolId;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="MinAvailableAddrNum")
    private Integer minAvailableAddrNum;
    @Query
    @NameInMap(value="Name")
    private String name;
    @Query
    @NameInMap(value="Type")
    @Validation(required=true)
    private String type;

    private UpdateGtmAddressPoolRequest(Builder builder) {
        super((Request.Builder)builder);
        this.addr = builder.addr;
        this.addrPoolId = builder.addrPoolId;
        this.lang = builder.lang;
        this.minAvailableAddrNum = builder.minAvailableAddrNum;
        this.name = builder.name;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateGtmAddressPoolRequest create() {
        return UpdateGtmAddressPoolRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<Addr> getAddr() {
        return this.addr;
    }

    public String getAddrPoolId() {
        return this.addrPoolId;
    }

    public String getLang() {
        return this.lang;
    }

    public Integer getMinAvailableAddrNum() {
        return this.minAvailableAddrNum;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public static class Addr
    extends TeaModel {
        @NameInMap(value="LbaWeight")
        private Integer lbaWeight;
        @NameInMap(value="Mode")
        private String mode;
        @NameInMap(value="Value")
        private String value;

        private Addr(Builder builder) {
            this.lbaWeight = builder.lbaWeight;
            this.mode = builder.mode;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Addr create() {
            return Addr.builder().build();
        }

        public Integer getLbaWeight() {
            return this.lbaWeight;
        }

        public String getMode() {
            return this.mode;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private Integer lbaWeight;
            private String mode;
            private String value;

            private Builder() {
            }

            private Builder(Addr model) {
                this.lbaWeight = model.lbaWeight;
                this.mode = model.mode;
                this.value = model.value;
            }

            public Builder lbaWeight(Integer lbaWeight) {
                this.lbaWeight = lbaWeight;
                return this;
            }

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Addr build() {
                return new Addr(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateGtmAddressPoolRequest, Builder> {
        private List<Addr> addr;
        private String addrPoolId;
        private String lang;
        private Integer minAvailableAddrNum;
        private String name;
        private String type;

        private Builder() {
        }

        private Builder(UpdateGtmAddressPoolRequest request) {
            super((Request)request);
            this.addr = request.addr;
            this.addrPoolId = request.addrPoolId;
            this.lang = request.lang;
            this.minAvailableAddrNum = request.minAvailableAddrNum;
            this.name = request.name;
            this.type = request.type;
        }

        public Builder addr(List<Addr> addr) {
            this.putQueryParameter("Addr", addr);
            this.addr = addr;
            return this;
        }

        public Builder addrPoolId(String addrPoolId) {
            this.putQueryParameter("AddrPoolId", addrPoolId);
            this.addrPoolId = addrPoolId;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder minAvailableAddrNum(Integer minAvailableAddrNum) {
            this.putQueryParameter("MinAvailableAddrNum", minAvailableAddrNum);
            this.minAvailableAddrNum = minAvailableAddrNum;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public UpdateGtmAddressPoolRequest build() {
            return new UpdateGtmAddressPoolRequest(this);
        }
    }
}

