/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alimt20181012.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class TranslateRequest
extends Request {
    @Query
    @NameInMap(value="Context")
    private String context;
    @Body
    @NameInMap(value="FormatType")
    @Validation(required=true)
    private String formatType;
    @Body
    @NameInMap(value="Scene")
    @Validation(required=true)
    private String scene;
    @Body
    @NameInMap(value="SourceLanguage")
    @Validation(required=true)
    private String sourceLanguage;
    @Body
    @NameInMap(value="SourceText")
    @Validation(required=true)
    private String sourceText;
    @Body
    @NameInMap(value="TargetLanguage")
    @Validation(required=true)
    private String targetLanguage;

    private TranslateRequest(Builder builder) {
        super((Request.Builder)builder);
        this.context = builder.context;
        this.formatType = builder.formatType;
        this.scene = builder.scene;
        this.sourceLanguage = builder.sourceLanguage;
        this.sourceText = builder.sourceText;
        this.targetLanguage = builder.targetLanguage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TranslateRequest create() {
        return TranslateRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getContext() {
        return this.context;
    }

    public String getFormatType() {
        return this.formatType;
    }

    public String getScene() {
        return this.scene;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    public static final class Builder
    extends Request.Builder<TranslateRequest, Builder> {
        private String context;
        private String formatType;
        private String scene;
        private String sourceLanguage;
        private String sourceText;
        private String targetLanguage;

        private Builder() {
        }

        private Builder(TranslateRequest request) {
            super((Request)request);
            this.context = request.context;
            this.formatType = request.formatType;
            this.scene = request.scene;
            this.sourceLanguage = request.sourceLanguage;
            this.sourceText = request.sourceText;
            this.targetLanguage = request.targetLanguage;
        }

        public Builder context(String context) {
            this.putQueryParameter("Context", context);
            this.context = context;
            return this;
        }

        public Builder formatType(String formatType) {
            this.putBodyParameter("FormatType", formatType);
            this.formatType = formatType;
            return this;
        }

        public Builder scene(String scene) {
            this.putBodyParameter("Scene", scene);
            this.scene = scene;
            return this;
        }

        public Builder sourceLanguage(String sourceLanguage) {
            this.putBodyParameter("SourceLanguage", sourceLanguage);
            this.sourceLanguage = sourceLanguage;
            return this;
        }

        public Builder sourceText(String sourceText) {
            this.putBodyParameter("SourceText", sourceText);
            this.sourceText = sourceText;
            return this;
        }

        public Builder targetLanguage(String targetLanguage) {
            this.putBodyParameter("TargetLanguage", targetLanguage);
            this.targetLanguage = targetLanguage;
            return this;
        }

        public TranslateRequest build() {
            return new TranslateRequest(this);
        }
    }
}

