/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dkms.gcs.openapi.util;

import com.aliyun.dkms.gcs.openapi.util.protobuf.ApiModels;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaPair;
import com.aliyun.teautil.Common;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Client {
    public static final String SDK_NAME = "kms-gcs-java-sdk-version";
    public static final String SDK_VERSKION = "0.5.2";

    public static Map<String, Object> getErrMessage(byte[] msg) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.Error response = ApiModels.Error.parseFrom(msg);
        result.put("Code", response.getErrorCode());
        result.put("Message", response.getErrorMessage());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static String getContentLength(byte[] reqBody) throws Exception {
        return String.valueOf(reqBody.length);
    }

    public static String getPrivatePemFromPk12(byte[] privateKeyData, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(new ByteArrayInputStream(privateKeyData), password.toCharArray());
        Enumeration<String> e = keyStore.aliases();
        String alias = e.nextElement();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        return Base64.getEncoder().encodeToString(privateKey.getEncoded());
    }

    public static String getStringToSign(String method, String pathname, Map<String, String> headers, Map<String, String> query) throws Exception {
        String date;
        String contentType;
        String contentSHA256 = headers.get("content-sha256");
        if (Common.isUnset((Object)contentSHA256)) {
            contentSHA256 = "";
        }
        if (Common.isUnset((Object)(contentType = headers.get("content-type")))) {
            contentType = "";
        }
        if (Common.isUnset((Object)(date = headers.get("date")))) {
            date = "";
        }
        String header = "" + method + "\n" + contentSHA256 + "\n" + contentType + "\n" + date + "\n";
        String canonicalizedHeaders = Client.getCanonicalizedHeaders(headers);
        String canonicalizedResource = Client.getCanonicalizedResource(pathname, query);
        return "" + header + "" + canonicalizedHeaders + "" + canonicalizedResource + "";
    }

    public static String getCanonicalizedHeaders(Map<String, String> headers) throws Exception {
        if (Common.isUnset(headers)) {
            return null;
        }
        String prefix = "x-kms-";
        List keys = com.aliyun.darabonba.map.Client.keySet(headers);
        List sortedKeys = com.aliyun.darabonba.array.Client.ascSort((List)keys);
        String canonicalizedHeaders = "";
        for (String key : sortedKeys) {
            if (!com.aliyun.darabonbastring.Client.hasPrefix((String)key, (String)prefix).booleanValue()) continue;
            canonicalizedHeaders = "" + canonicalizedHeaders + "" + key + ":" + com.aliyun.darabonbastring.Client.trim((String)headers.get(key)) + "\n";
        }
        return canonicalizedHeaders;
    }

    public static String getCanonicalizedResource(String pathname, Map<String, String> query) throws Exception {
        if (!Common.isUnset((Object)pathname)) {
            return "/";
        }
        if (Common.isUnset(query)) {
            return pathname;
        }
        String canonicalizedResource = "";
        List queryArray = com.aliyun.darabonba.map.Client.keySet(query);
        List sortedQueryArray = com.aliyun.darabonba.array.Client.ascSort((List)queryArray);
        String separator = "";
        canonicalizedResource = "" + pathname + "?";
        for (String key : sortedQueryArray) {
            canonicalizedResource = "" + canonicalizedResource + "" + separator + "" + key + "";
            if (!Common.empty((String)query.get(key))) {
                canonicalizedResource = "" + canonicalizedResource + "=" + query.get(key) + "";
            }
            separator = "&";
        }
        return canonicalizedResource;
    }

    public static String getCaCertFromContent(byte[] reqBody) throws Exception {
        return Client.resolveSubCa(Common.toString((byte[])reqBody));
    }

    public static String getCaCertFromFile(String reqBody) throws Exception {
        String caCerts = Client.readFileContent(reqBody);
        return Client.resolveSubCa(caCerts);
    }

    public static String resolveSubCa(String caCerts) throws Exception {
        if (Common.isUnset((Object)caCerts)) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'CA' can not be empty")}));
        }
        Integer length = com.aliyun.darabonbanumber.Client.parseInt((String)Client.getContentLength(com.aliyun.darabonbastring.Client.toBytes((String)caCerts, (String)"UTF-8")));
        Long endIndex = com.aliyun.darabonbanumber.Client.itol((Integer)com.aliyun.darabonbastring.Client.index((String)caCerts, (String)"-----END CERTIFICATE-----"));
        Long suffixLength = com.aliyun.darabonbanumber.Client.itol((Integer)25);
        Integer subCaStart = com.aliyun.darabonbanumber.Client.ltoi((Long)com.aliyun.darabonbanumber.Client.add((Long)endIndex, (Long)suffixLength));
        String rootCa = com.aliyun.darabonbastring.Client.subString((String)caCerts, (Integer)0, (Integer)subCaStart);
        String subCa = com.aliyun.darabonbastring.Client.subString((String)caCerts, (Integer)subCaStart, (Integer)length);
        if (Common.empty((String)com.aliyun.darabonbastring.Client.trim((String)subCa))) {
            return rootCa;
        }
        return subCa;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileContent(String filePath) throws Exception {
        File file = Client.getFileByPath(filePath);
        if (file == null || !file.exists()) {
            try (InputStream in = Client.class.getClassLoader().getResourceAsStream(filePath);){
                String string = Client.readContent(in);
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            String string = Client.readContent(inputStream);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File getFileByPath(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            URL resource = Client.class.getClassLoader().getResource("");
            String path = "";
            if (resource != null) {
                path = resource.getPath();
            }
            if (!(file = new File(path + filePath)).exists() && !(file = new File(path = Paths.get(filePath, new String[0]).toAbsolutePath().toString())).exists()) {
                return null;
            }
        }
        return file;
    }

    private static String readContent(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        StringBuffer content = new StringBuffer();
        byte[] input = new byte[inputStream.available()];
        while (inputStream.read(input) != -1) {
            content.append(new String(input, 0, input.length));
        }
        return content.toString();
    }

    public static Boolean defaultBoolean(Boolean bool1, Boolean bool2) throws Exception {
        if (Common.isUnset((Object)bool1)) {
            return bool2;
        }
        return bool1;
    }

    public static Boolean isRetryErr(Exception err) throws Exception {
        if (err instanceof TeaException) {
            String code = ((TeaException)err).getCode();
            String message = ((TeaException)err).getMessage();
            if ("Rejected.Throttling".equals(code) || message.contains("The Param Content-SHA256 is invalid.")) {
                return true;
            }
        }
        return false;
    }

    public static String getUserAgent(String userAgent) {
        Properties sysProps = System.getProperties();
        if (userAgent != null) {
            return String.format("AlibabaCloud (%s; %s) Java/%s %s %s/%s", sysProps.getProperty("os.name"), sysProps.getProperty("os.arch"), sysProps.getProperty("java.runtime.version"), userAgent, SDK_NAME, SDK_VERSKION);
        }
        return String.format("AlibabaCloud (%s; %s) Java/%s %s/%s", sysProps.getProperty("os.name"), sysProps.getProperty("os.arch"), sysProps.getProperty("java.runtime.version"), SDK_NAME, SDK_VERSKION);
    }

    public static Map<String, Object> parseEncryptResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.EncryptResponse response = ApiModels.EncryptResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("CiphertextBlob", response.getCiphertextBlob().toByteArray());
        result.put("Iv", response.getIv().toByteArray());
        result.put("RequestId", response.getRequestId());
        result.put("Algorithm", response.getAlgorithm());
        result.put("PaddingMode", response.getPaddingMode());
        return result;
    }

    public static byte[] getSerializedDecryptRequest(Map<String, Object> reqBody) throws Exception {
        Object paddingMode;
        Object iv;
        Object aad;
        Object algorithm;
        Object keyId;
        ApiModels.DecryptRequest.Builder builder = ApiModels.DecryptRequest.newBuilder();
        Object ciphertextBlob = reqBody.get("CiphertextBlob");
        if (ciphertextBlob != null) {
            builder.setCiphertextBlob(ByteString.copyFrom((byte[])((byte[])ciphertextBlob)));
        }
        if ((keyId = reqBody.get("KeyId")) != null) {
            builder.setKeyId((String)keyId);
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        if ((iv = reqBody.get("Iv")) != null) {
            builder.setIv(ByteString.copyFrom((byte[])((byte[])iv)));
        }
        if ((paddingMode = reqBody.get("PaddingMode")) != null) {
            builder.setPaddingMode((String)paddingMode);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseDecryptResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.DecryptResponse response = ApiModels.DecryptResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Plaintext", response.getPlaintext().toByteArray());
        result.put("RequestId", response.getRequestId());
        result.put("Algorithm", response.getAlgorithm());
        result.put("PaddingMode", response.getPaddingMode());
        return result;
    }

    public static byte[] getSerializedSignRequest(Map<String, Object> reqBody) throws Exception {
        Object messageType;
        Object message;
        Object algorithm;
        Object digest;
        ApiModels.SignRequest.Builder builder = ApiModels.SignRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((digest = reqBody.get("Digest")) != null) {
            builder.setDigest(ByteString.copyFrom((byte[])((byte[])digest)));
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((message = reqBody.get("Message")) != null) {
            builder.setMessage(ByteString.copyFrom((byte[])((byte[])message)));
        }
        if ((messageType = reqBody.get("MessageType")) != null) {
            builder.setMessageType((String)messageType);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseSignResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.SignResponse response = ApiModels.SignResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Signature", response.getSignature().toByteArray());
        result.put("RequestId", response.getRequestId());
        result.put("Algorithm", response.getAlgorithm());
        result.put("MessageType", response.getMessageType());
        return result;
    }

    public static byte[] getSerializedVerifyRequest(Map<String, Object> reqBody) throws Exception {
        Object messageType;
        Object message;
        Object algorithm;
        Object signature;
        Object digest;
        ApiModels.VerifyRequest.Builder builder = ApiModels.VerifyRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((digest = reqBody.get("Digest")) != null) {
            builder.setDigest(ByteString.copyFrom((byte[])((byte[])digest)));
        }
        if ((signature = reqBody.get("Signature")) != null) {
            builder.setSignature(ByteString.copyFrom((byte[])((byte[])signature)));
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((message = reqBody.get("Message")) != null) {
            builder.setMessage(ByteString.copyFrom((byte[])((byte[])message)));
        }
        if ((messageType = reqBody.get("MessageType")) != null) {
            builder.setMessageType((String)messageType);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseVerifyResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.VerifyResponse response = ApiModels.VerifyResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Value", response.getValue());
        result.put("RequestId", response.getRequestId());
        result.put("Algorithm", response.getAlgorithm());
        result.put("MessageType", response.getMessageType());
        return result;
    }

    public static byte[] getSerializedGenerateRandomRequest(Map<String, Object> reqBody) throws Exception {
        ApiModels.GenerateRandomRequest.Builder builder = ApiModels.GenerateRandomRequest.newBuilder();
        Object length = reqBody.get("Length");
        if (length != null) {
            builder.setLength((Integer)length);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseGenerateRandomResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.GenerateRandomResponse response = ApiModels.GenerateRandomResponse.parseFrom(resBody);
        result.put("Random", response.getRandom().toByteArray());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedGenerateDataKeyRequest(Map<String, Object> reqBody) throws Exception {
        Object aad;
        Object numberOfBytes;
        Object algorithm;
        ApiModels.GenerateDataKeyRequest.Builder builder = ApiModels.GenerateDataKeyRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((numberOfBytes = reqBody.get("NumberOfBytes")) != null) {
            builder.setNumberOfBytes((Integer)numberOfBytes);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseGenerateDataKeyResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.GenerateDataKeyResponse response = ApiModels.GenerateDataKeyResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Iv", response.getIv().toByteArray());
        result.put("Plaintext", response.getPlaintext().toByteArray());
        result.put("CiphertextBlob", response.getCiphertextBlob().toByteArray());
        result.put("RequestId", response.getRequestId());
        result.put("Algorithm", response.getAlgorithm());
        return result;
    }

    public static byte[] getSerializedGetPublicKeyRequest(Map<String, Object> reqBody) throws Exception {
        ApiModels.GetPublicKeyRequest.Builder builder = ApiModels.GetPublicKeyRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseGetPublicKeyResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.GetPublicKeyResponse response = ApiModels.GetPublicKeyResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("PublicKey", response.getPublicKey());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    public static byte[] getSerializedGetSecretValueRequest(Map<String, Object> reqBody) throws Exception {
        Object fetchExtendedConfig;
        Object versionId;
        Object versionStage;
        ApiModels.GetSecretValueRequest.Builder builder = ApiModels.GetSecretValueRequest.newBuilder();
        Object secretName = reqBody.get("SecretName");
        if (secretName != null) {
            builder.setSecretName((String)secretName);
        }
        if ((versionStage = reqBody.get("VersionStage")) != null) {
            builder.setVersionStage((String)versionStage);
        }
        if ((versionId = reqBody.get("VersionId")) != null) {
            builder.setVersionId((String)versionId);
        }
        if ((fetchExtendedConfig = reqBody.get("FetchExtendedConfig")) != null) {
            builder.setFetchExtendedConfig((Boolean)fetchExtendedConfig);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseGetSecretValueResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.GetSecretValueResponse response = ApiModels.GetSecretValueResponse.parseFrom(resBody);
        result.put("SecretName", response.getSecretName());
        result.put("SecretType", response.getSecretType());
        result.put("SecretData", response.getSecretData());
        result.put("SecretDataType", response.getSecretDataType());
        result.put("VersionStages", response.getVersionStagesList());
        result.put("VersionId", response.getVersionId());
        result.put("CreateTime", response.getCreateTime());
        result.put("RequestId", response.getRequestId());
        result.put("LastRotationDate", response.getLastRotationDate());
        result.put("NextRotationDate", response.getNextRotationDate());
        result.put("ExtendedConfig", response.getExtendedConfig());
        result.put("AutomaticRotation", response.getAutomaticRotation());
        result.put("RotationInterval", response.getRotationInterval());
        return result;
    }

    public static byte[] getSerializedAdvanceEncryptRequest(Map<String, Object> reqBody) throws Exception {
        Object paddingMode;
        Object iv;
        Object aad;
        Object algorithm;
        Object plaintext;
        ApiModels.AdvanceEncryptRequest.Builder builder = ApiModels.AdvanceEncryptRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((plaintext = reqBody.get("Plaintext")) != null) {
            builder.setPlaintext(ByteString.copyFrom((byte[])((byte[])plaintext)));
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        if ((iv = reqBody.get("Iv")) != null) {
            builder.setIv(ByteString.copyFrom((byte[])((byte[])iv)));
        }
        if ((paddingMode = reqBody.get("PaddingMode")) != null) {
            builder.setPaddingMode((String)paddingMode);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseAdvanceEncryptResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.AdvanceEncryptResponse response = ApiModels.AdvanceEncryptResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("CiphertextBlob", response.getCiphertextBlob().toByteArray());
        result.put("Iv", response.getIv().toByteArray());
        result.put("RequestId", response.getRequestId());
        result.put("Algorithm", response.getAlgorithm());
        result.put("PaddingMode", response.getPaddingMode());
        result.put("KeyVersionId", response.getKeyVersionId());
        return result;
    }

    public static byte[] getSerializedAdvanceDecryptRequest(Map<String, Object> reqBody) throws Exception {
        Object paddingMode;
        Object iv;
        Object aad;
        Object algorithm;
        Object keyId;
        ApiModels.AdvanceDecryptRequest.Builder builder = ApiModels.AdvanceDecryptRequest.newBuilder();
        Object ciphertextBlob = reqBody.get("CiphertextBlob");
        if (ciphertextBlob != null) {
            builder.setCiphertextBlob(ByteString.copyFrom((byte[])((byte[])ciphertextBlob)));
        }
        if ((keyId = reqBody.get("KeyId")) != null) {
            builder.setKeyId((String)keyId);
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        if ((iv = reqBody.get("Iv")) != null) {
            builder.setIv(ByteString.copyFrom((byte[])((byte[])iv)));
        }
        if ((paddingMode = reqBody.get("PaddingMode")) != null) {
            builder.setPaddingMode((String)paddingMode);
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseAdvanceDecryptResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.AdvanceDecryptResponse response = ApiModels.AdvanceDecryptResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Plaintext", response.getPlaintext().toByteArray());
        result.put("RequestId", response.getRequestId());
        result.put("Algorithm", response.getAlgorithm());
        result.put("PaddingMode", response.getPaddingMode());
        result.put("KeyVersionId", response.getKeyVersionId());
        return result;
    }

    public static byte[] getSerializedAdvanceGenerateDataKeyRequest(Map<String, Object> reqBody) throws Exception {
        Object aad;
        Object numberOfBytes;
        ApiModels.AdvanceGenerateDataKeyRequest.Builder builder = ApiModels.AdvanceGenerateDataKeyRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((numberOfBytes = reqBody.get("NumberOfBytes")) != null) {
            builder.setNumberOfBytes((Integer)numberOfBytes);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseAdvanceGenerateDataKeyResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.AdvanceGenerateDataKeyResponse response = ApiModels.AdvanceGenerateDataKeyResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Iv", response.getIv().toByteArray());
        result.put("Plaintext", response.getPlaintext().toByteArray());
        result.put("CiphertextBlob", response.getCiphertextBlob().toByteArray());
        result.put("RequestId", response.getRequestId());
        result.put("Algorithm", response.getAlgorithm());
        result.put("KeyVersionId", response.getKeyVersionId());
        return result;
    }

    public static byte[] getSerializedEncryptRequest(Map<String, Object> reqBody) throws Exception {
        Object paddingMode;
        Object iv;
        Object aad;
        Object algorithm;
        Object plaintext;
        ApiModels.EncryptRequest.Builder builder = ApiModels.EncryptRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((plaintext = reqBody.get("Plaintext")) != null) {
            builder.setPlaintext(ByteString.copyFrom((byte[])((byte[])plaintext)));
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        if ((iv = reqBody.get("Iv")) != null) {
            builder.setIv(ByteString.copyFrom((byte[])((byte[])iv)));
        }
        if ((paddingMode = reqBody.get("PaddingMode")) != null) {
            builder.setPaddingMode((String)paddingMode);
        }
        return builder.build().toByteArray();
    }

    public static byte[] getSerializedGenerateDataKeyPairRequest(Map<String, Object> reqBody) throws Exception {
        Object aad;
        Object keyFormat;
        Object keyPairSpec;
        Object algorithm;
        ApiModels.GenerateDataKeyPairRequest.Builder builder = ApiModels.GenerateDataKeyPairRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((keyPairSpec = reqBody.get("KeyPairSpec")) != null) {
            builder.setKeyPairSpec((String)keyPairSpec);
        }
        if ((keyFormat = reqBody.get("KeyFormat")) != null) {
            builder.setKeyFormat((String)keyFormat);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseGenerateDataKeyPairResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.GenerateDataKeyPairResponse response = ApiModels.GenerateDataKeyPairResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Iv", response.getIv().toByteArray());
        result.put("KeyPairSpec", response.getKeyPairSpec());
        result.put("PrivateKeyPlaintext", response.getPrivateKeyPlaintext().toByteArray());
        result.put("PrivateKeyCiphertextBlob", response.getPrivateKeyCiphertextBlob().toByteArray());
        result.put("PublicKey", response.getPublicKey().toByteArray());
        result.put("RequestId", response.getRequestId());
        result.put("Algorithm", response.getAlgorithm());
        return result;
    }

    public static byte[] getSerializedGenerateDataKeyPairWithoutPlaintextRequest(Map<String, Object> reqBody) throws Exception {
        Object aad;
        Object keyFormat;
        Object keyPairSpec;
        Object algorithm;
        ApiModels.GenerateDataKeyPairWithoutPlaintextRequest.Builder builder = ApiModels.GenerateDataKeyPairWithoutPlaintextRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((algorithm = reqBody.get("Algorithm")) != null) {
            builder.setAlgorithm((String)algorithm);
        }
        if ((keyPairSpec = reqBody.get("KeyPairSpec")) != null) {
            builder.setKeyPairSpec((String)keyPairSpec);
        }
        if ((keyFormat = reqBody.get("KeyFormat")) != null) {
            builder.setKeyFormat((String)keyFormat);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseGenerateDataKeyPairWithoutPlaintextResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.GenerateDataKeyPairWithoutPlaintextResponse response = ApiModels.GenerateDataKeyPairWithoutPlaintextResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Iv", response.getIv().toByteArray());
        result.put("KeyPairSpec", response.getKeyPairSpec());
        result.put("PrivateKeyCiphertextBlob", response.getPrivateKeyCiphertextBlob().toByteArray());
        result.put("PublicKey", response.getPublicKey().toByteArray());
        result.put("RequestId", response.getRequestId());
        result.put("Algorithm", response.getAlgorithm());
        return result;
    }

    public static byte[] getSerializedAdvanceGenerateDataKeyPairRequest(Map<String, Object> reqBody) throws Exception {
        Object aad;
        Object keyFormat;
        Object keyPairSpec;
        ApiModels.AdvanceGenerateDataKeyPairRequest.Builder builder = ApiModels.AdvanceGenerateDataKeyPairRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((keyPairSpec = reqBody.get("KeyPairSpec")) != null) {
            builder.setKeyPairSpec((String)keyPairSpec);
        }
        if ((keyFormat = reqBody.get("KeyFormat")) != null) {
            builder.setKeyFormat((String)keyFormat);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseAdvanceGenerateDataKeyPairResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.AdvanceGenerateDataKeyPairResponse response = ApiModels.AdvanceGenerateDataKeyPairResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Iv", response.getIv().toByteArray());
        result.put("KeyPairSpec", response.getKeyPairSpec());
        result.put("PrivateKeyPlaintext", response.getPrivateKeyPlaintext().toByteArray());
        result.put("PrivateKeyCiphertextBlob", response.getPrivateKeyCiphertextBlob().toByteArray());
        result.put("PublicKey", response.getPublicKey().toByteArray());
        result.put("RequestId", response.getRequestId());
        result.put("Algorithm", response.getAlgorithm());
        result.put("KeyVersionId", response.getKeyVersionId());
        return result;
    }

    public static byte[] getSerializedAdvanceGenerateDataKeyPairWithoutPlaintextRequest(Map<String, Object> reqBody) throws Exception {
        Object aad;
        Object keyFormat;
        Object keyPairSpec;
        ApiModels.AdvanceGenerateDataKeyPairWithoutPlaintextRequest.Builder builder = ApiModels.AdvanceGenerateDataKeyPairWithoutPlaintextRequest.newBuilder();
        Object keyId = reqBody.get("KeyId");
        if (keyId != null) {
            builder.setKeyId((String)keyId);
        }
        if ((keyPairSpec = reqBody.get("KeyPairSpec")) != null) {
            builder.setKeyPairSpec((String)keyPairSpec);
        }
        if ((keyFormat = reqBody.get("KeyFormat")) != null) {
            builder.setKeyFormat((String)keyFormat);
        }
        if ((aad = reqBody.get("Aad")) != null) {
            builder.setAad(ByteString.copyFrom((byte[])((byte[])aad)));
        }
        return builder.build().toByteArray();
    }

    public static Map<String, Object> parseAdvanceGenerateDataKeyPairWithoutPlaintextResponse(byte[] resBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApiModels.AdvanceGenerateDataKeyPairWithoutPlaintextResponse response = ApiModels.AdvanceGenerateDataKeyPairWithoutPlaintextResponse.parseFrom(resBody);
        result.put("KeyId", response.getKeyId());
        result.put("Iv", response.getIv().toByteArray());
        result.put("KeyPairSpec", response.getKeyPairSpec());
        result.put("PrivateKeyCiphertextBlob", response.getPrivateKeyCiphertextBlob().toByteArray());
        result.put("PublicKey", response.getPublicKey().toByteArray());
        result.put("RequestId", response.getRequestId());
        result.put("Algorithm", response.getAlgorithm());
        result.put("KeyVersionId", response.getKeyVersionId());
        return result;
    }
}

