/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.dysmsapi20170525.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class AddExtCodeSignRequest
extends Request {
    @Query
    @NameInMap(value="ExtCode")
    @Validation(required=true)
    private String extCode;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;
    @Query
    @NameInMap(value="SignName")
    @Validation(required=true)
    private String signName;

    private AddExtCodeSignRequest(Builder builder) {
        super((Request.Builder)builder);
        this.extCode = builder.extCode;
        this.ownerId = builder.ownerId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.signName = builder.signName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddExtCodeSignRequest create() {
        return AddExtCodeSignRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getExtCode() {
        return this.extCode;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public String getSignName() {
        return this.signName;
    }

    public static final class Builder
    extends Request.Builder<AddExtCodeSignRequest, Builder> {
        private String extCode;
        private Long ownerId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;
        private String signName;

        private Builder() {
        }

        private Builder(AddExtCodeSignRequest request) {
            super((Request)request);
            this.extCode = request.extCode;
            this.ownerId = request.ownerId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
            this.signName = request.signName;
        }

        public Builder extCode(String extCode) {
            this.putQueryParameter("ExtCode", extCode);
            this.extCode = extCode;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder signName(String signName) {
            this.putQueryParameter("SignName", signName);
            this.signName = signName;
            return this;
        }

        public AddExtCodeSignRequest build() {
            return new AddExtCodeSignRequest(this);
        }
    }
}

