/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.dysmsapi20170525.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;
import java.util.Map;

public class QueryMobilesCardSupportRequest
extends Request {
    @Query
    @NameInMap(value="EncryptType")
    @Validation(maxLength=100)
    private String encryptType;
    @Query
    @NameInMap(value="Mobiles")
    @Validation(required=true)
    private List<Map<String, ?>> mobiles;
    @Query
    @NameInMap(value="TemplateCode")
    @Validation(required=true)
    private String templateCode;

    private QueryMobilesCardSupportRequest(Builder builder) {
        super((Request.Builder)builder);
        this.encryptType = builder.encryptType;
        this.mobiles = builder.mobiles;
        this.templateCode = builder.templateCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryMobilesCardSupportRequest create() {
        return QueryMobilesCardSupportRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getEncryptType() {
        return this.encryptType;
    }

    public List<Map<String, ?>> getMobiles() {
        return this.mobiles;
    }

    public String getTemplateCode() {
        return this.templateCode;
    }

    public static final class Builder
    extends Request.Builder<QueryMobilesCardSupportRequest, Builder> {
        private String encryptType;
        private List<Map<String, ?>> mobiles;
        private String templateCode;

        private Builder() {
        }

        private Builder(QueryMobilesCardSupportRequest request) {
            super((Request)request);
            this.encryptType = request.encryptType;
            this.mobiles = request.mobiles;
            this.templateCode = request.templateCode;
        }

        public Builder encryptType(String encryptType) {
            this.putQueryParameter("EncryptType", encryptType);
            this.encryptType = encryptType;
            return this;
        }

        public Builder mobiles(List<Map<String, ?>> mobiles) {
            String mobilesShrink = this.shrink(mobiles, "Mobiles", "json");
            this.putQueryParameter("Mobiles", mobilesShrink);
            this.mobiles = mobiles;
            return this;
        }

        public Builder templateCode(String templateCode) {
            this.putQueryParameter("TemplateCode", templateCode);
            this.templateCode = templateCode;
            return this;
        }

        public QueryMobilesCardSupportRequest build() {
            return new QueryMobilesCardSupportRequest(this);
        }
    }
}

