/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.dytnsapi20200217.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UAIDVerificationRequest
extends Request {
    @Query
    @NameInMap(value="AuthCode")
    @Validation(required=true)
    private String authCode;
    @Query
    @NameInMap(value="Carrier")
    @Validation(required=true)
    private String carrier;
    @Query
    @NameInMap(value="Ip")
    private String ip;
    @Query
    @NameInMap(value="OutId")
    private String outId;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="Province")
    private String province;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;
    @Query
    @NameInMap(value="Token")
    @Validation(required=true)
    private String token;
    @Query
    @NameInMap(value="UserGrantId")
    private String userGrantId;

    private UAIDVerificationRequest(Builder builder) {
        super((Request.Builder)builder);
        this.authCode = builder.authCode;
        this.carrier = builder.carrier;
        this.ip = builder.ip;
        this.outId = builder.outId;
        this.ownerId = builder.ownerId;
        this.province = builder.province;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.token = builder.token;
        this.userGrantId = builder.userGrantId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UAIDVerificationRequest create() {
        return UAIDVerificationRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public String getIp() {
        return this.ip;
    }

    public String getOutId() {
        return this.outId;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getProvince() {
        return this.province;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public String getToken() {
        return this.token;
    }

    public String getUserGrantId() {
        return this.userGrantId;
    }

    public static final class Builder
    extends Request.Builder<UAIDVerificationRequest, Builder> {
        private String authCode;
        private String carrier;
        private String ip;
        private String outId;
        private Long ownerId;
        private String province;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;
        private String token;
        private String userGrantId;

        private Builder() {
        }

        private Builder(UAIDVerificationRequest request) {
            super((Request)request);
            this.authCode = request.authCode;
            this.carrier = request.carrier;
            this.ip = request.ip;
            this.outId = request.outId;
            this.ownerId = request.ownerId;
            this.province = request.province;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
            this.token = request.token;
            this.userGrantId = request.userGrantId;
        }

        public Builder authCode(String authCode) {
            this.putQueryParameter("AuthCode", authCode);
            this.authCode = authCode;
            return this;
        }

        public Builder carrier(String carrier) {
            this.putQueryParameter("Carrier", carrier);
            this.carrier = carrier;
            return this;
        }

        public Builder ip(String ip) {
            this.putQueryParameter("Ip", ip);
            this.ip = ip;
            return this;
        }

        public Builder outId(String outId) {
            this.putQueryParameter("OutId", outId);
            this.outId = outId;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder province(String province) {
            this.putQueryParameter("Province", province);
            this.province = province;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public Builder token(String token) {
            this.putQueryParameter("Token", token);
            this.token = token;
            return this;
        }

        public Builder userGrantId(String userGrantId) {
            this.putQueryParameter("UserGrantId", userGrantId);
            this.userGrantId = userGrantId;
            return this;
        }

        public UAIDVerificationRequest build() {
            return new UAIDVerificationRequest(this);
        }
    }
}

