/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class CloneServiceRequest
extends Request {
    @Path
    @NameInMap(value="ClusterId")
    @Validation(required=true)
    private String clusterId;
    @Path
    @NameInMap(value="ServiceName")
    @Validation(required=true)
    private String serviceName;
    @Query
    @NameInMap(value="Labels")
    private Map<String, String> labels;
    @Body
    @NameInMap(value="body")
    private String body;

    private CloneServiceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clusterId = builder.clusterId;
        this.serviceName = builder.serviceName;
        this.labels = builder.labels;
        this.body = builder.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CloneServiceRequest create() {
        return CloneServiceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getBody() {
        return this.body;
    }

    public static final class Builder
    extends Request.Builder<CloneServiceRequest, Builder> {
        private String clusterId;
        private String serviceName;
        private Map<String, String> labels;
        private String body;

        private Builder() {
        }

        private Builder(CloneServiceRequest request) {
            super((Request)request);
            this.clusterId = request.clusterId;
            this.serviceName = request.serviceName;
            this.labels = request.labels;
            this.body = request.body;
        }

        public Builder clusterId(String clusterId) {
            this.putPathParameter("ClusterId", clusterId);
            this.clusterId = clusterId;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.putPathParameter("ServiceName", serviceName);
            this.serviceName = serviceName;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            String labelsShrink = this.shrink(labels, "Labels", "json");
            this.putQueryParameter("Labels", labelsShrink);
            this.labels = labels;
            return this;
        }

        public Builder body(String body) {
            this.putBodyParameter("body", body);
            this.body = body;
            return this;
        }

        public CloneServiceRequest build() {
            return new CloneServiceRequest(this);
        }
    }
}

