/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateGatewayRequest
extends Request {
    @Query
    @NameInMap(value="ResourceName")
    private String resourceName;
    @Body
    @NameInMap(value="EnableInternet")
    private Boolean enableInternet;
    @Body
    @NameInMap(value="EnableIntranet")
    private Boolean enableIntranet;
    @Body
    @NameInMap(value="InstanceType")
    @Validation(required=true)
    private String instanceType;
    @Body
    @NameInMap(value="Name")
    private String name;
    @Body
    @NameInMap(value="Replicas")
    private Integer replicas;

    private CreateGatewayRequest(Builder builder) {
        super((Request.Builder)builder);
        this.resourceName = builder.resourceName;
        this.enableInternet = builder.enableInternet;
        this.enableIntranet = builder.enableIntranet;
        this.instanceType = builder.instanceType;
        this.name = builder.name;
        this.replicas = builder.replicas;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateGatewayRequest create() {
        return CreateGatewayRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Boolean getEnableInternet() {
        return this.enableInternet;
    }

    public Boolean getEnableIntranet() {
        return this.enableIntranet;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getName() {
        return this.name;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public static final class Builder
    extends Request.Builder<CreateGatewayRequest, Builder> {
        private String resourceName;
        private Boolean enableInternet;
        private Boolean enableIntranet;
        private String instanceType;
        private String name;
        private Integer replicas;

        private Builder() {
        }

        private Builder(CreateGatewayRequest request) {
            super((Request)request);
            this.resourceName = request.resourceName;
            this.enableInternet = request.enableInternet;
            this.enableIntranet = request.enableIntranet;
            this.instanceType = request.instanceType;
            this.name = request.name;
            this.replicas = request.replicas;
        }

        public Builder resourceName(String resourceName) {
            this.putQueryParameter("ResourceName", resourceName);
            this.resourceName = resourceName;
            return this;
        }

        public Builder enableInternet(Boolean enableInternet) {
            this.putBodyParameter("EnableInternet", enableInternet);
            this.enableInternet = enableInternet;
            return this;
        }

        public Builder enableIntranet(Boolean enableIntranet) {
            this.putBodyParameter("EnableIntranet", enableIntranet);
            this.enableIntranet = enableIntranet;
            return this;
        }

        public Builder instanceType(String instanceType) {
            this.putBodyParameter("InstanceType", instanceType);
            this.instanceType = instanceType;
            return this;
        }

        public Builder name(String name) {
            this.putBodyParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder replicas(Integer replicas) {
            this.putBodyParameter("Replicas", replicas);
            this.replicas = replicas;
            return this;
        }

        public CreateGatewayRequest build() {
            return new CreateGatewayRequest(this);
        }
    }
}

