/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateResourceInstancesRequest
extends Request {
    @Path
    @NameInMap(value="ClusterId")
    @Validation(required=true)
    private String clusterId;
    @Path
    @NameInMap(value="ResourceId")
    @Validation(required=true)
    private String resourceId;
    @Body
    @NameInMap(value="AutoRenewal")
    private Boolean autoRenewal;
    @Body
    @NameInMap(value="ChargeType")
    @Validation(required=true)
    private String chargeType;
    @Body
    @NameInMap(value="EcsInstanceCount")
    @Validation(required=true)
    private Integer ecsInstanceCount;
    @Body
    @NameInMap(value="EcsInstanceType")
    @Validation(required=true)
    private String ecsInstanceType;
    @Body
    @NameInMap(value="SystemDiskSize")
    @Validation(maximum=2000.0, minimum=200.0)
    private Integer systemDiskSize;
    @Body
    @NameInMap(value="UserData")
    private String userData;
    @Body
    @NameInMap(value="Zone")
    private String zone;

    private CreateResourceInstancesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clusterId = builder.clusterId;
        this.resourceId = builder.resourceId;
        this.autoRenewal = builder.autoRenewal;
        this.chargeType = builder.chargeType;
        this.ecsInstanceCount = builder.ecsInstanceCount;
        this.ecsInstanceType = builder.ecsInstanceType;
        this.systemDiskSize = builder.systemDiskSize;
        this.userData = builder.userData;
        this.zone = builder.zone;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateResourceInstancesRequest create() {
        return CreateResourceInstancesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Boolean getAutoRenewal() {
        return this.autoRenewal;
    }

    public String getChargeType() {
        return this.chargeType;
    }

    public Integer getEcsInstanceCount() {
        return this.ecsInstanceCount;
    }

    public String getEcsInstanceType() {
        return this.ecsInstanceType;
    }

    public Integer getSystemDiskSize() {
        return this.systemDiskSize;
    }

    public String getUserData() {
        return this.userData;
    }

    public String getZone() {
        return this.zone;
    }

    public static final class Builder
    extends Request.Builder<CreateResourceInstancesRequest, Builder> {
        private String clusterId;
        private String resourceId;
        private Boolean autoRenewal;
        private String chargeType;
        private Integer ecsInstanceCount;
        private String ecsInstanceType;
        private Integer systemDiskSize;
        private String userData;
        private String zone;

        private Builder() {
        }

        private Builder(CreateResourceInstancesRequest request) {
            super((Request)request);
            this.clusterId = request.clusterId;
            this.resourceId = request.resourceId;
            this.autoRenewal = request.autoRenewal;
            this.chargeType = request.chargeType;
            this.ecsInstanceCount = request.ecsInstanceCount;
            this.ecsInstanceType = request.ecsInstanceType;
            this.systemDiskSize = request.systemDiskSize;
            this.userData = request.userData;
            this.zone = request.zone;
        }

        public Builder clusterId(String clusterId) {
            this.putPathParameter("ClusterId", clusterId);
            this.clusterId = clusterId;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.putPathParameter("ResourceId", resourceId);
            this.resourceId = resourceId;
            return this;
        }

        public Builder autoRenewal(Boolean autoRenewal) {
            this.putBodyParameter("AutoRenewal", autoRenewal);
            this.autoRenewal = autoRenewal;
            return this;
        }

        public Builder chargeType(String chargeType) {
            this.putBodyParameter("ChargeType", chargeType);
            this.chargeType = chargeType;
            return this;
        }

        public Builder ecsInstanceCount(Integer ecsInstanceCount) {
            this.putBodyParameter("EcsInstanceCount", ecsInstanceCount);
            this.ecsInstanceCount = ecsInstanceCount;
            return this;
        }

        public Builder ecsInstanceType(String ecsInstanceType) {
            this.putBodyParameter("EcsInstanceType", ecsInstanceType);
            this.ecsInstanceType = ecsInstanceType;
            return this;
        }

        public Builder systemDiskSize(Integer systemDiskSize) {
            this.putBodyParameter("SystemDiskSize", systemDiskSize);
            this.systemDiskSize = systemDiskSize;
            return this;
        }

        public Builder userData(String userData) {
            this.putBodyParameter("UserData", userData);
            this.userData = userData;
            return this;
        }

        public Builder zone(String zone) {
            this.putBodyParameter("Zone", zone);
            this.zone = zone;
            return this;
        }

        public CreateResourceInstancesRequest build() {
            return new CreateResourceInstancesRequest(this);
        }
    }
}

