/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;
import java.util.Map;

public class CreateResourceRequest
extends Request {
    @Body
    @NameInMap(value="AutoRenewal")
    private Boolean autoRenewal;
    @Body
    @NameInMap(value="ChargeType")
    private String chargeType;
    @Body
    @NameInMap(value="EcsInstanceCount")
    private Integer ecsInstanceCount;
    @Body
    @NameInMap(value="EcsInstanceType")
    private String ecsInstanceType;
    @Body
    @NameInMap(value="ResourceType")
    private String resourceType;
    @Body
    @NameInMap(value="SelfManagedResourceOptions")
    private SelfManagedResourceOptions selfManagedResourceOptions;
    @Body
    @NameInMap(value="SystemDiskSize")
    @Validation(maximum=2000.0, minimum=200.0)
    private Integer systemDiskSize;
    @Body
    @NameInMap(value="Zone")
    private String zone;

    private CreateResourceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.autoRenewal = builder.autoRenewal;
        this.chargeType = builder.chargeType;
        this.ecsInstanceCount = builder.ecsInstanceCount;
        this.ecsInstanceType = builder.ecsInstanceType;
        this.resourceType = builder.resourceType;
        this.selfManagedResourceOptions = builder.selfManagedResourceOptions;
        this.systemDiskSize = builder.systemDiskSize;
        this.zone = builder.zone;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateResourceRequest create() {
        return CreateResourceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Boolean getAutoRenewal() {
        return this.autoRenewal;
    }

    public String getChargeType() {
        return this.chargeType;
    }

    public Integer getEcsInstanceCount() {
        return this.ecsInstanceCount;
    }

    public String getEcsInstanceType() {
        return this.ecsInstanceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public SelfManagedResourceOptions getSelfManagedResourceOptions() {
        return this.selfManagedResourceOptions;
    }

    public Integer getSystemDiskSize() {
        return this.systemDiskSize;
    }

    public String getZone() {
        return this.zone;
    }

    public static class SelfManagedResourceOptions
    extends TeaModel {
        @NameInMap(value="ExternalClusterId")
        private String externalClusterId;
        @NameInMap(value="NodeMatchLabels")
        private Map<String, String> nodeMatchLabels;
        @NameInMap(value="NodeTolerations")
        private List<NodeTolerations> nodeTolerations;
        @NameInMap(value="RoleName")
        private String roleName;

        private SelfManagedResourceOptions(Builder builder) {
            this.externalClusterId = builder.externalClusterId;
            this.nodeMatchLabels = builder.nodeMatchLabels;
            this.nodeTolerations = builder.nodeTolerations;
            this.roleName = builder.roleName;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SelfManagedResourceOptions create() {
            return SelfManagedResourceOptions.builder().build();
        }

        public String getExternalClusterId() {
            return this.externalClusterId;
        }

        public Map<String, String> getNodeMatchLabels() {
            return this.nodeMatchLabels;
        }

        public List<NodeTolerations> getNodeTolerations() {
            return this.nodeTolerations;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public static final class Builder {
            private String externalClusterId;
            private Map<String, String> nodeMatchLabels;
            private List<NodeTolerations> nodeTolerations;
            private String roleName;

            public Builder externalClusterId(String externalClusterId) {
                this.externalClusterId = externalClusterId;
                return this;
            }

            public Builder nodeMatchLabels(Map<String, String> nodeMatchLabels) {
                this.nodeMatchLabels = nodeMatchLabels;
                return this;
            }

            public Builder nodeTolerations(List<NodeTolerations> nodeTolerations) {
                this.nodeTolerations = nodeTolerations;
                return this;
            }

            public Builder roleName(String roleName) {
                this.roleName = roleName;
                return this;
            }

            public SelfManagedResourceOptions build() {
                return new SelfManagedResourceOptions(this);
            }
        }
    }

    public static class NodeTolerations
    extends TeaModel {
        @NameInMap(value="effect")
        private String effect;
        @NameInMap(value="key")
        private String key;
        @NameInMap(value="operator")
        private String operator;
        @NameInMap(value="value")
        private String value;

        private NodeTolerations(Builder builder) {
            this.effect = builder.effect;
            this.key = builder.key;
            this.operator = builder.operator;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static NodeTolerations create() {
            return NodeTolerations.builder().build();
        }

        public String getEffect() {
            return this.effect;
        }

        public String getKey() {
            return this.key;
        }

        public String getOperator() {
            return this.operator;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String effect;
            private String key;
            private String operator;
            private String value;

            public Builder effect(String effect) {
                this.effect = effect;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder operator(String operator) {
                this.operator = operator;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public NodeTolerations build() {
                return new NodeTolerations(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateResourceRequest, Builder> {
        private Boolean autoRenewal;
        private String chargeType;
        private Integer ecsInstanceCount;
        private String ecsInstanceType;
        private String resourceType;
        private SelfManagedResourceOptions selfManagedResourceOptions;
        private Integer systemDiskSize;
        private String zone;

        private Builder() {
        }

        private Builder(CreateResourceRequest request) {
            super((Request)request);
            this.autoRenewal = request.autoRenewal;
            this.chargeType = request.chargeType;
            this.ecsInstanceCount = request.ecsInstanceCount;
            this.ecsInstanceType = request.ecsInstanceType;
            this.resourceType = request.resourceType;
            this.selfManagedResourceOptions = request.selfManagedResourceOptions;
            this.systemDiskSize = request.systemDiskSize;
            this.zone = request.zone;
        }

        public Builder autoRenewal(Boolean autoRenewal) {
            this.putBodyParameter("AutoRenewal", autoRenewal);
            this.autoRenewal = autoRenewal;
            return this;
        }

        public Builder chargeType(String chargeType) {
            this.putBodyParameter("ChargeType", chargeType);
            this.chargeType = chargeType;
            return this;
        }

        public Builder ecsInstanceCount(Integer ecsInstanceCount) {
            this.putBodyParameter("EcsInstanceCount", ecsInstanceCount);
            this.ecsInstanceCount = ecsInstanceCount;
            return this;
        }

        public Builder ecsInstanceType(String ecsInstanceType) {
            this.putBodyParameter("EcsInstanceType", ecsInstanceType);
            this.ecsInstanceType = ecsInstanceType;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.putBodyParameter("ResourceType", resourceType);
            this.resourceType = resourceType;
            return this;
        }

        public Builder selfManagedResourceOptions(SelfManagedResourceOptions selfManagedResourceOptions) {
            this.putBodyParameter("SelfManagedResourceOptions", (Object)selfManagedResourceOptions);
            this.selfManagedResourceOptions = selfManagedResourceOptions;
            return this;
        }

        public Builder systemDiskSize(Integer systemDiskSize) {
            this.putBodyParameter("SystemDiskSize", systemDiskSize);
            this.systemDiskSize = systemDiskSize;
            return this;
        }

        public Builder zone(String zone) {
            this.putBodyParameter("Zone", zone);
            this.zone = zone;
            return this;
        }

        public CreateResourceRequest build() {
            return new CreateResourceRequest(this);
        }
    }
}

