/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateServiceAutoScalerRequest
extends Request {
    @Path
    @NameInMap(value="ClusterId")
    @Validation(required=true)
    private String clusterId;
    @Path
    @NameInMap(value="ServiceName")
    @Validation(required=true)
    private String serviceName;
    @Body
    @NameInMap(value="behavior")
    private Behavior behavior;
    @Body
    @NameInMap(value="max")
    @Validation(required=true)
    private Integer max;
    @Body
    @NameInMap(value="min")
    @Validation(required=true)
    private Integer min;
    @Body
    @NameInMap(value="scaleStrategies")
    @Validation(required=true)
    private List<ScaleStrategies> scaleStrategies;

    private CreateServiceAutoScalerRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clusterId = builder.clusterId;
        this.serviceName = builder.serviceName;
        this.behavior = builder.behavior;
        this.max = builder.max;
        this.min = builder.min;
        this.scaleStrategies = builder.scaleStrategies;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateServiceAutoScalerRequest create() {
        return CreateServiceAutoScalerRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public Integer getMax() {
        return this.max;
    }

    public Integer getMin() {
        return this.min;
    }

    public List<ScaleStrategies> getScaleStrategies() {
        return this.scaleStrategies;
    }

    public static class ScaleStrategies
    extends TeaModel {
        @NameInMap(value="metricName")
        @Validation(required=true)
        private String metricName;
        @NameInMap(value="service")
        private String service;
        @NameInMap(value="threshold")
        @Validation(required=true)
        private Float threshold;

        private ScaleStrategies(Builder builder) {
            this.metricName = builder.metricName;
            this.service = builder.service;
            this.threshold = builder.threshold;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ScaleStrategies create() {
            return ScaleStrategies.builder().build();
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getService() {
            return this.service;
        }

        public Float getThreshold() {
            return this.threshold;
        }

        public static final class Builder {
            private String metricName;
            private String service;
            private Float threshold;

            public Builder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public Builder service(String service) {
                this.service = service;
                return this;
            }

            public Builder threshold(Float threshold) {
                this.threshold = threshold;
                return this;
            }

            public ScaleStrategies build() {
                return new ScaleStrategies(this);
            }
        }
    }

    public static class Behavior
    extends TeaModel {
        @NameInMap(value="onZero")
        private OnZero onZero;
        @NameInMap(value="scaleDown")
        private ScaleDown scaleDown;
        @NameInMap(value="scaleUp")
        private ScaleUp scaleUp;

        private Behavior(Builder builder) {
            this.onZero = builder.onZero;
            this.scaleDown = builder.scaleDown;
            this.scaleUp = builder.scaleUp;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Behavior create() {
            return Behavior.builder().build();
        }

        public OnZero getOnZero() {
            return this.onZero;
        }

        public ScaleDown getScaleDown() {
            return this.scaleDown;
        }

        public ScaleUp getScaleUp() {
            return this.scaleUp;
        }

        public static final class Builder {
            private OnZero onZero;
            private ScaleDown scaleDown;
            private ScaleUp scaleUp;

            public Builder onZero(OnZero onZero) {
                this.onZero = onZero;
                return this;
            }

            public Builder scaleDown(ScaleDown scaleDown) {
                this.scaleDown = scaleDown;
                return this;
            }

            public Builder scaleUp(ScaleUp scaleUp) {
                this.scaleUp = scaleUp;
                return this;
            }

            public Behavior build() {
                return new Behavior(this);
            }
        }
    }

    public static class ScaleUp
    extends TeaModel {
        @NameInMap(value="stabilizationWindowSeconds")
        private Integer stabilizationWindowSeconds;

        private ScaleUp(Builder builder) {
            this.stabilizationWindowSeconds = builder.stabilizationWindowSeconds;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ScaleUp create() {
            return ScaleUp.builder().build();
        }

        public Integer getStabilizationWindowSeconds() {
            return this.stabilizationWindowSeconds;
        }

        public static final class Builder {
            private Integer stabilizationWindowSeconds;

            public Builder stabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
                this.stabilizationWindowSeconds = stabilizationWindowSeconds;
                return this;
            }

            public ScaleUp build() {
                return new ScaleUp(this);
            }
        }
    }

    public static class ScaleDown
    extends TeaModel {
        @NameInMap(value="stabilizationWindowSeconds")
        private Integer stabilizationWindowSeconds;

        private ScaleDown(Builder builder) {
            this.stabilizationWindowSeconds = builder.stabilizationWindowSeconds;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ScaleDown create() {
            return ScaleDown.builder().build();
        }

        public Integer getStabilizationWindowSeconds() {
            return this.stabilizationWindowSeconds;
        }

        public static final class Builder {
            private Integer stabilizationWindowSeconds;

            public Builder stabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
                this.stabilizationWindowSeconds = stabilizationWindowSeconds;
                return this;
            }

            public ScaleDown build() {
                return new ScaleDown(this);
            }
        }
    }

    public static class OnZero
    extends TeaModel {
        @NameInMap(value="scaleDownGracePeriodSeconds")
        private Integer scaleDownGracePeriodSeconds;
        @NameInMap(value="scaleUpActivationReplicas")
        private Integer scaleUpActivationReplicas;

        private OnZero(Builder builder) {
            this.scaleDownGracePeriodSeconds = builder.scaleDownGracePeriodSeconds;
            this.scaleUpActivationReplicas = builder.scaleUpActivationReplicas;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static OnZero create() {
            return OnZero.builder().build();
        }

        public Integer getScaleDownGracePeriodSeconds() {
            return this.scaleDownGracePeriodSeconds;
        }

        public Integer getScaleUpActivationReplicas() {
            return this.scaleUpActivationReplicas;
        }

        public static final class Builder {
            private Integer scaleDownGracePeriodSeconds;
            private Integer scaleUpActivationReplicas;

            public Builder scaleDownGracePeriodSeconds(Integer scaleDownGracePeriodSeconds) {
                this.scaleDownGracePeriodSeconds = scaleDownGracePeriodSeconds;
                return this;
            }

            public Builder scaleUpActivationReplicas(Integer scaleUpActivationReplicas) {
                this.scaleUpActivationReplicas = scaleUpActivationReplicas;
                return this;
            }

            public OnZero build() {
                return new OnZero(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateServiceAutoScalerRequest, Builder> {
        private String clusterId;
        private String serviceName;
        private Behavior behavior;
        private Integer max;
        private Integer min;
        private List<ScaleStrategies> scaleStrategies;

        private Builder() {
        }

        private Builder(CreateServiceAutoScalerRequest request) {
            super((Request)request);
            this.clusterId = request.clusterId;
            this.serviceName = request.serviceName;
            this.behavior = request.behavior;
            this.max = request.max;
            this.min = request.min;
            this.scaleStrategies = request.scaleStrategies;
        }

        public Builder clusterId(String clusterId) {
            this.putPathParameter("ClusterId", clusterId);
            this.clusterId = clusterId;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.putPathParameter("ServiceName", serviceName);
            this.serviceName = serviceName;
            return this;
        }

        public Builder behavior(Behavior behavior) {
            this.putBodyParameter("behavior", (Object)behavior);
            this.behavior = behavior;
            return this;
        }

        public Builder max(Integer max) {
            this.putBodyParameter("max", max);
            this.max = max;
            return this;
        }

        public Builder min(Integer min) {
            this.putBodyParameter("min", min);
            this.min = min;
            return this;
        }

        public Builder scaleStrategies(List<ScaleStrategies> scaleStrategies) {
            this.putBodyParameter("scaleStrategies", scaleStrategies);
            this.scaleStrategies = scaleStrategies;
            return this;
        }

        public CreateServiceAutoScalerRequest build() {
            return new CreateServiceAutoScalerRequest(this);
        }
    }
}

