/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateServiceCronScalerRequest
extends Request {
    @Path
    @NameInMap(value="ClusterId")
    @Validation(required=true)
    private String clusterId;
    @Path
    @NameInMap(value="ServiceName")
    @Validation(required=true)
    private String serviceName;
    @Body
    @NameInMap(value="ExcludeDates")
    private List<String> excludeDates;
    @Body
    @NameInMap(value="ScaleJobs")
    @Validation(required=true)
    private List<ScaleJobs> scaleJobs;

    private CreateServiceCronScalerRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clusterId = builder.clusterId;
        this.serviceName = builder.serviceName;
        this.excludeDates = builder.excludeDates;
        this.scaleJobs = builder.scaleJobs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateServiceCronScalerRequest create() {
        return CreateServiceCronScalerRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<String> getExcludeDates() {
        return this.excludeDates;
    }

    public List<ScaleJobs> getScaleJobs() {
        return this.scaleJobs;
    }

    public static class ScaleJobs
    extends TeaModel {
        @NameInMap(value="Name")
        private String name;
        @NameInMap(value="Schedule")
        @Validation(required=true)
        private String schedule;
        @NameInMap(value="TargetSize")
        @Validation(required=true)
        private Integer targetSize;

        private ScaleJobs(Builder builder) {
            this.name = builder.name;
            this.schedule = builder.schedule;
            this.targetSize = builder.targetSize;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ScaleJobs create() {
            return ScaleJobs.builder().build();
        }

        public String getName() {
            return this.name;
        }

        public String getSchedule() {
            return this.schedule;
        }

        public Integer getTargetSize() {
            return this.targetSize;
        }

        public static final class Builder {
            private String name;
            private String schedule;
            private Integer targetSize;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder schedule(String schedule) {
                this.schedule = schedule;
                return this;
            }

            public Builder targetSize(Integer targetSize) {
                this.targetSize = targetSize;
                return this;
            }

            public ScaleJobs build() {
                return new ScaleJobs(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateServiceCronScalerRequest, Builder> {
        private String clusterId;
        private String serviceName;
        private List<String> excludeDates;
        private List<ScaleJobs> scaleJobs;

        private Builder() {
        }

        private Builder(CreateServiceCronScalerRequest request) {
            super((Request)request);
            this.clusterId = request.clusterId;
            this.serviceName = request.serviceName;
            this.excludeDates = request.excludeDates;
            this.scaleJobs = request.scaleJobs;
        }

        public Builder clusterId(String clusterId) {
            this.putPathParameter("ClusterId", clusterId);
            this.clusterId = clusterId;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.putPathParameter("ServiceName", serviceName);
            this.serviceName = serviceName;
            return this;
        }

        public Builder excludeDates(List<String> excludeDates) {
            this.putBodyParameter("ExcludeDates", excludeDates);
            this.excludeDates = excludeDates;
            return this;
        }

        public Builder scaleJobs(List<ScaleJobs> scaleJobs) {
            this.putBodyParameter("ScaleJobs", scaleJobs);
            this.scaleJobs = scaleJobs;
            return this;
        }

        public CreateServiceCronScalerRequest build() {
            return new CreateServiceCronScalerRequest(this);
        }
    }
}

