/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class CreateServiceRequest
extends Request {
    @Query
    @NameInMap(value="Develop")
    private String develop;
    @Query
    @NameInMap(value="Labels")
    private Map<String, String> labels;
    @Query
    @NameInMap(value="WorkspaceId")
    private String workspaceId;
    @Body
    @NameInMap(value="body")
    private String body;

    private CreateServiceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.develop = builder.develop;
        this.labels = builder.labels;
        this.workspaceId = builder.workspaceId;
        this.body = builder.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateServiceRequest create() {
        return CreateServiceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDevelop() {
        return this.develop;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getBody() {
        return this.body;
    }

    public static final class Builder
    extends Request.Builder<CreateServiceRequest, Builder> {
        private String develop;
        private Map<String, String> labels;
        private String workspaceId;
        private String body;

        private Builder() {
        }

        private Builder(CreateServiceRequest request) {
            super((Request)request);
            this.develop = request.develop;
            this.labels = request.labels;
            this.workspaceId = request.workspaceId;
            this.body = request.body;
        }

        public Builder develop(String develop) {
            this.putQueryParameter("Develop", develop);
            this.develop = develop;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            String labelsShrink = this.shrink(labels, "Labels", "json");
            this.putQueryParameter("Labels", labelsShrink);
            this.labels = labels;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.putQueryParameter("WorkspaceId", workspaceId);
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder body(String body) {
            this.putBodyParameter("body", body);
            this.body = body;
            return this;
        }

        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }
    }
}

