/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class DeleteAclPolicyRequest
extends Request {
    @Path
    @NameInMap(value="ClusterId")
    @Validation(required=true)
    private String clusterId;
    @Path
    @NameInMap(value="GatewayId")
    @Validation(required=true)
    private String gatewayId;
    @Query
    @NameInMap(value="AclPolicyList")
    private List<AclPolicyList> aclPolicyList;
    @Query
    @NameInMap(value="VpcId")
    private String vpcId;

    private DeleteAclPolicyRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clusterId = builder.clusterId;
        this.gatewayId = builder.gatewayId;
        this.aclPolicyList = builder.aclPolicyList;
        this.vpcId = builder.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DeleteAclPolicyRequest create() {
        return DeleteAclPolicyRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public List<AclPolicyList> getAclPolicyList() {
        return this.aclPolicyList;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public static class AclPolicyList
    extends TeaModel {
        @NameInMap(value="Comment")
        private String comment;
        @NameInMap(value="Entry")
        private String entry;

        private AclPolicyList(Builder builder) {
            this.comment = builder.comment;
            this.entry = builder.entry;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AclPolicyList create() {
            return AclPolicyList.builder().build();
        }

        public String getComment() {
            return this.comment;
        }

        public String getEntry() {
            return this.entry;
        }

        public static final class Builder {
            private String comment;
            private String entry;

            public Builder comment(String comment) {
                this.comment = comment;
                return this;
            }

            public Builder entry(String entry) {
                this.entry = entry;
                return this;
            }

            public AclPolicyList build() {
                return new AclPolicyList(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<DeleteAclPolicyRequest, Builder> {
        private String clusterId;
        private String gatewayId;
        private List<AclPolicyList> aclPolicyList;
        private String vpcId;

        private Builder() {
        }

        private Builder(DeleteAclPolicyRequest request) {
            super((Request)request);
            this.clusterId = request.clusterId;
            this.gatewayId = request.gatewayId;
            this.aclPolicyList = request.aclPolicyList;
            this.vpcId = request.vpcId;
        }

        public Builder clusterId(String clusterId) {
            this.putPathParameter("ClusterId", clusterId);
            this.clusterId = clusterId;
            return this;
        }

        public Builder gatewayId(String gatewayId) {
            this.putPathParameter("GatewayId", gatewayId);
            this.gatewayId = gatewayId;
            return this;
        }

        public Builder aclPolicyList(List<AclPolicyList> aclPolicyList) {
            String aclPolicyListShrink = this.shrink(aclPolicyList, "AclPolicyList", "json");
            this.putQueryParameter("AclPolicyList", aclPolicyListShrink);
            this.aclPolicyList = aclPolicyList;
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.putQueryParameter("VpcId", vpcId);
            this.vpcId = vpcId;
            return this;
        }

        public DeleteAclPolicyRequest build() {
            return new DeleteAclPolicyRequest(this);
        }
    }
}

