/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class DeleteServiceLabelRequest
extends Request {
    @Path
    @NameInMap(value="ClusterId")
    @Validation(required=true)
    private String clusterId;
    @Path
    @NameInMap(value="ServiceName")
    @Validation(required=true)
    private String serviceName;
    @Query
    @NameInMap(value="Keys")
    @Validation(required=true)
    private List<String> keys;

    private DeleteServiceLabelRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clusterId = builder.clusterId;
        this.serviceName = builder.serviceName;
        this.keys = builder.keys;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DeleteServiceLabelRequest create() {
        return DeleteServiceLabelRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public static final class Builder
    extends Request.Builder<DeleteServiceLabelRequest, Builder> {
        private String clusterId;
        private String serviceName;
        private List<String> keys;

        private Builder() {
        }

        private Builder(DeleteServiceLabelRequest request) {
            super((Request)request);
            this.clusterId = request.clusterId;
            this.serviceName = request.serviceName;
            this.keys = request.keys;
        }

        public Builder clusterId(String clusterId) {
            this.putPathParameter("ClusterId", clusterId);
            this.clusterId = clusterId;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.putPathParameter("ServiceName", serviceName);
            this.serviceName = serviceName;
            return this;
        }

        public Builder keys(List<String> keys) {
            String keysShrink = this.shrink(keys, "Keys", "simple");
            this.putQueryParameter("Keys", keysShrink);
            this.keys = keys;
            return this;
        }

        public DeleteServiceLabelRequest build() {
            return new DeleteServiceLabelRequest(this);
        }
    }
}

