/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListGroupsRequest
extends Request {
    @Query
    @NameInMap(value="Filter")
    private String filter;
    @Query
    @NameInMap(value="PageNumber")
    private String pageNumber;
    @Query
    @NameInMap(value="PageSize")
    private String pageSize;
    @Query
    @NameInMap(value="WorkspaceId")
    private String workspaceId;

    private ListGroupsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.filter = builder.filter;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.workspaceId = builder.workspaceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListGroupsRequest create() {
        return ListGroupsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getFilter() {
        return this.filter;
    }

    public String getPageNumber() {
        return this.pageNumber;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public static final class Builder
    extends Request.Builder<ListGroupsRequest, Builder> {
        private String filter;
        private String pageNumber;
        private String pageSize;
        private String workspaceId;

        private Builder() {
        }

        private Builder(ListGroupsRequest request) {
            super((Request)request);
            this.filter = request.filter;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.workspaceId = request.workspaceId;
        }

        public Builder filter(String filter) {
            this.putQueryParameter("Filter", filter);
            this.filter = filter;
            return this;
        }

        public Builder pageNumber(String pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(String pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.putQueryParameter("WorkspaceId", workspaceId);
            this.workspaceId = workspaceId;
            return this;
        }

        public ListGroupsRequest build() {
            return new ListGroupsRequest(this);
        }
    }
}

