/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListResourceServicesRequest
extends Request {
    @Path
    @NameInMap(value="ClusterId")
    @Validation(required=true)
    private String clusterId;
    @Path
    @NameInMap(value="ResourceId")
    @Validation(required=true)
    private String resourceId;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;

    private ListResourceServicesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clusterId = builder.clusterId;
        this.resourceId = builder.resourceId;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListResourceServicesRequest create() {
        return ListResourceServicesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<ListResourceServicesRequest, Builder> {
        private String clusterId;
        private String resourceId;
        private Integer pageNumber;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(ListResourceServicesRequest request) {
            super((Request)request);
            this.clusterId = request.clusterId;
            this.resourceId = request.resourceId;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
        }

        public Builder clusterId(String clusterId) {
            this.putPathParameter("ClusterId", clusterId);
            this.clusterId = clusterId;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.putPathParameter("ResourceId", resourceId);
            this.resourceId = resourceId;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public ListResourceServicesRequest build() {
            return new ListResourceServicesRequest(this);
        }
    }
}

