/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListServiceVersionsRequest
extends Request {
    @Path
    @NameInMap(value="ClusterId")
    @Validation(required=true)
    private String clusterId;
    @Path
    @NameInMap(value="ServiceName")
    @Validation(required=true)
    private String serviceName;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;

    private ListServiceVersionsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clusterId = builder.clusterId;
        this.serviceName = builder.serviceName;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListServiceVersionsRequest create() {
        return ListServiceVersionsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<ListServiceVersionsRequest, Builder> {
        private String clusterId;
        private String serviceName;
        private Integer pageNumber;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(ListServiceVersionsRequest request) {
            super((Request)request);
            this.clusterId = request.clusterId;
            this.serviceName = request.serviceName;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
        }

        public Builder clusterId(String clusterId) {
            this.putPathParameter("ClusterId", clusterId);
            this.clusterId = clusterId;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.putPathParameter("ServiceName", serviceName);
            this.serviceName = serviceName;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public ListServiceVersionsRequest build() {
            return new ListServiceVersionsRequest(this);
        }
    }
}

