/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class UpdateAppServiceRequest
extends Request {
    @Path
    @NameInMap(value="ClusterId")
    @Validation(required=true)
    private String clusterId;
    @Path
    @NameInMap(value="ServiceName")
    @Validation(required=true)
    private String serviceName;
    @Query
    @NameInMap(value="QuotaId")
    private String quotaId;
    @Query
    @NameInMap(value="WorkspaceId")
    private String workspaceId;
    @Body
    @NameInMap(value="AppType")
    private String appType;
    @Body
    @NameInMap(value="AppVersion")
    private String appVersion;
    @Body
    @NameInMap(value="Config")
    private Map<String, ?> config;
    @Body
    @NameInMap(value="Replicas")
    private Integer replicas;
    @Body
    @NameInMap(value="ServiceSpec")
    private String serviceSpec;

    private UpdateAppServiceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clusterId = builder.clusterId;
        this.serviceName = builder.serviceName;
        this.quotaId = builder.quotaId;
        this.workspaceId = builder.workspaceId;
        this.appType = builder.appType;
        this.appVersion = builder.appVersion;
        this.config = builder.config;
        this.replicas = builder.replicas;
        this.serviceSpec = builder.serviceSpec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateAppServiceRequest create() {
        return UpdateAppServiceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getQuotaId() {
        return this.quotaId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getAppType() {
        return this.appType;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public Map<String, ?> getConfig() {
        return this.config;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public String getServiceSpec() {
        return this.serviceSpec;
    }

    public static final class Builder
    extends Request.Builder<UpdateAppServiceRequest, Builder> {
        private String clusterId;
        private String serviceName;
        private String quotaId;
        private String workspaceId;
        private String appType;
        private String appVersion;
        private Map<String, ?> config;
        private Integer replicas;
        private String serviceSpec;

        private Builder() {
        }

        private Builder(UpdateAppServiceRequest request) {
            super((Request)request);
            this.clusterId = request.clusterId;
            this.serviceName = request.serviceName;
            this.quotaId = request.quotaId;
            this.workspaceId = request.workspaceId;
            this.appType = request.appType;
            this.appVersion = request.appVersion;
            this.config = request.config;
            this.replicas = request.replicas;
            this.serviceSpec = request.serviceSpec;
        }

        public Builder clusterId(String clusterId) {
            this.putPathParameter("ClusterId", clusterId);
            this.clusterId = clusterId;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.putPathParameter("ServiceName", serviceName);
            this.serviceName = serviceName;
            return this;
        }

        public Builder quotaId(String quotaId) {
            this.putQueryParameter("QuotaId", quotaId);
            this.quotaId = quotaId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.putQueryParameter("WorkspaceId", workspaceId);
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder appType(String appType) {
            this.putBodyParameter("AppType", appType);
            this.appType = appType;
            return this;
        }

        public Builder appVersion(String appVersion) {
            this.putBodyParameter("AppVersion", appVersion);
            this.appVersion = appVersion;
            return this;
        }

        public Builder config(Map<String, ?> config) {
            this.putBodyParameter("Config", config);
            this.config = config;
            return this;
        }

        public Builder replicas(Integer replicas) {
            this.putBodyParameter("Replicas", replicas);
            this.replicas = replicas;
            return this;
        }

        public Builder serviceSpec(String serviceSpec) {
            this.putBodyParameter("ServiceSpec", serviceSpec);
            this.serviceSpec = serviceSpec;
            return this;
        }

        public UpdateAppServiceRequest build() {
            return new UpdateAppServiceRequest(this);
        }
    }
}

