/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.eas20210701.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;
import java.util.Map;

public class UpdateResourceRequest
extends Request {
    @Path
    @NameInMap(value="ClusterId")
    @Validation(required=true)
    private String clusterId;
    @Path
    @NameInMap(value="ResourceId")
    @Validation(required=true)
    private String resourceId;
    @Body
    @NameInMap(value="ResourceName")
    private String resourceName;
    @Body
    @NameInMap(value="SelfManagedResourceOptions")
    private SelfManagedResourceOptions selfManagedResourceOptions;

    private UpdateResourceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clusterId = builder.clusterId;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.selfManagedResourceOptions = builder.selfManagedResourceOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateResourceRequest create() {
        return UpdateResourceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public SelfManagedResourceOptions getSelfManagedResourceOptions() {
        return this.selfManagedResourceOptions;
    }

    public static class SelfManagedResourceOptions
    extends TeaModel {
        @NameInMap(value="NodeMatchLabels")
        private Map<String, String> nodeMatchLabels;
        @NameInMap(value="NodeTolerations")
        private List<NodeTolerations> nodeTolerations;

        private SelfManagedResourceOptions(Builder builder) {
            this.nodeMatchLabels = builder.nodeMatchLabels;
            this.nodeTolerations = builder.nodeTolerations;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SelfManagedResourceOptions create() {
            return SelfManagedResourceOptions.builder().build();
        }

        public Map<String, String> getNodeMatchLabels() {
            return this.nodeMatchLabels;
        }

        public List<NodeTolerations> getNodeTolerations() {
            return this.nodeTolerations;
        }

        public static final class Builder {
            private Map<String, String> nodeMatchLabels;
            private List<NodeTolerations> nodeTolerations;

            public Builder nodeMatchLabels(Map<String, String> nodeMatchLabels) {
                this.nodeMatchLabels = nodeMatchLabels;
                return this;
            }

            public Builder nodeTolerations(List<NodeTolerations> nodeTolerations) {
                this.nodeTolerations = nodeTolerations;
                return this;
            }

            public SelfManagedResourceOptions build() {
                return new SelfManagedResourceOptions(this);
            }
        }
    }

    public static class NodeTolerations
    extends TeaModel {
        @NameInMap(value="effect")
        private String effect;
        @NameInMap(value="key")
        private String key;
        @NameInMap(value="operator")
        private String operator;
        @NameInMap(value="value")
        private String value;

        private NodeTolerations(Builder builder) {
            this.effect = builder.effect;
            this.key = builder.key;
            this.operator = builder.operator;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static NodeTolerations create() {
            return NodeTolerations.builder().build();
        }

        public String getEffect() {
            return this.effect;
        }

        public String getKey() {
            return this.key;
        }

        public String getOperator() {
            return this.operator;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String effect;
            private String key;
            private String operator;
            private String value;

            public Builder effect(String effect) {
                this.effect = effect;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder operator(String operator) {
                this.operator = operator;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public NodeTolerations build() {
                return new NodeTolerations(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateResourceRequest, Builder> {
        private String clusterId;
        private String resourceId;
        private String resourceName;
        private SelfManagedResourceOptions selfManagedResourceOptions;

        private Builder() {
        }

        private Builder(UpdateResourceRequest request) {
            super((Request)request);
            this.clusterId = request.clusterId;
            this.resourceId = request.resourceId;
            this.resourceName = request.resourceName;
            this.selfManagedResourceOptions = request.selfManagedResourceOptions;
        }

        public Builder clusterId(String clusterId) {
            this.putPathParameter("ClusterId", clusterId);
            this.clusterId = clusterId;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.putPathParameter("ResourceId", resourceId);
            this.resourceId = resourceId;
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.putBodyParameter("ResourceName", resourceName);
            this.resourceName = resourceName;
            return this;
        }

        public Builder selfManagedResourceOptions(SelfManagedResourceOptions selfManagedResourceOptions) {
            this.putBodyParameter("SelfManagedResourceOptions", (Object)selfManagedResourceOptions);
            this.selfManagedResourceOptions = selfManagedResourceOptions;
            return this;
        }

        public UpdateResourceRequest build() {
            return new UpdateResourceRequest(this);
        }
    }
}

