/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.gateway.oss;

import com.aliyun.darabonba.encode.Encoder;
import com.aliyun.darabonba.signature.Signer;
import com.aliyun.gateway.spi.models.AttributeMap;
import com.aliyun.gateway.spi.models.InterceptorContext;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaPair;
import com.aliyun.teautil.Common;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Client
extends com.aliyun.gateway.spi.Client {
    public List<String> _default_signed_params = Arrays.asList("location", "cors", "objectMeta", "uploadId", "partNumber", "security-token", "position", "img", "style", "styleName", "replication", "replicationProgress", "replicationLocation", "cname", "qos", "startTime", "endTime", "symlink", "x-oss-process", "response-content-type", "response-content-language", "response-expires", "response-cache-control", "response-content-disposition", "response-content-encoding", "udf", "udfName", "udfImage", "udfId", "udfImageDesc", "udfApplication", "udfApplicationLog", "restore", "callback", "callback-var", "policy", "encryption", "versions", "versioning", "versionId", "wormId");
    public List<String> _except_signed_params = Arrays.asList("list-type", "regions");

    public void modifyConfiguration(InterceptorContext context, AttributeMap attributeMap) throws Exception {
        InterceptorContext.InterceptorContextConfiguration config = context.configuration;
        config.endpoint = this.getEndpoint(config.regionId, config.network, config.endpoint);
    }

    public void modifyRequest(InterceptorContext context, AttributeMap attributeMap) throws Exception {
        String bucketName;
        InterceptorContext.InterceptorContextRequest request = context.request;
        Map hostMap = new HashMap();
        if (!Common.isUnset((Object)request.hostMap)) {
            hostMap = request.hostMap;
        }
        if (Common.isUnset((Object)(bucketName = (String)hostMap.get("bucket")))) {
            bucketName = "";
        }
        if (!Common.isUnset(request.headers.get("x-oss-meta-*"))) {
            Object tmp = Common.parseJSON((String)((String)request.headers.get("x-oss-meta-*")));
            Map mapData = Common.assertAsMap((Object)tmp);
            Map metaData = Common.stringifyMapValue((Map)mapData);
            List metaKeySet = com.aliyun.darabonba.map.Client.keySet((Map)metaData);
            request.headers.put("x-oss-meta-*", null);
            for (String key : metaKeySet) {
                String newKey = "x-oss-meta-" + key + "";
                request.headers.put(newKey, metaData.get(key));
            }
        }
        InterceptorContext.InterceptorContextConfiguration config = context.configuration;
        com.aliyun.credentials.Client credential = request.credential;
        String accessKeyId = credential.getAccessKeyId();
        String accessKeySecret = credential.getAccessKeySecret();
        String securityToken = credential.getSecurityToken();
        if (!Common.empty((String)securityToken)) {
            request.headers.put("x-oss-security-token", securityToken);
        }
        if (!Common.isUnset((Object)request.body)) {
            if (com.aliyun.darabonbastring.Client.equals((String)request.reqBodyType, (String)"xml").booleanValue()) {
                Map reqBodyMap = Common.assertAsMap((Object)request.body);
                request.stream = Tea.toReadable((String)com.aliyun.teaxml.Client.toXML((Map)reqBodyMap));
                request.headers.put("content-type", "application/xml");
            } else if (com.aliyun.darabonbastring.Client.equals((String)request.reqBodyType, (String)"json").booleanValue()) {
                String reqBodyStr = Common.toJSONString((Object)request.body);
                request.stream = Tea.toReadable((String)reqBodyStr);
                request.headers.put("content-type", "application/json; charset=utf-8");
            } else if (com.aliyun.darabonbastring.Client.equals((String)request.reqBodyType, (String)"formData").booleanValue()) {
                Map reqBodyForm = Common.assertAsMap((Object)request.body);
                request.stream = Tea.toReadable((String)com.aliyun.openapiutil.Client.toForm((Map)reqBodyForm));
                request.headers.put("content-type", "application/x-www-form-urlencoded");
            } else if (com.aliyun.darabonbastring.Client.equals((String)request.reqBodyType, (String)"binary").booleanValue()) {
                attributeMap.key = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("crc", (Object)""), new TeaPair("md5", (Object)"")});
                request.stream = com.aliyun.ossutil.Client.inject((InputStream)request.stream, (Map)attributeMap.key);
                request.headers.put("content-type", "application/octet-stream");
            }
        }
        String host = this.getHost(config.endpointType, bucketName, config.endpoint);
        request.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)host), new TeaPair("date", (Object)Common.getDateUTCString()), new TeaPair("user-agent", (Object)request.userAgent)}), request.headers});
        request.headers.put("authorization", this.getAuthorization(request.signatureVersion, bucketName, request.pathname, request.method, request.query, request.headers, accessKeyId, accessKeySecret));
    }

    public void modifyResponse(InterceptorContext context, AttributeMap attributeMap) throws Exception {
        InterceptorContext.InterceptorContextRequest request = context.request;
        InterceptorContext.InterceptorContextResponse response = context.response;
        String bodyStr = null;
        if (Common.is4xx((Number)response.statusCode) || Common.is5xx((Number)response.statusCode)) {
            bodyStr = Common.readAsString((InputStream)response.body);
            if (!Common.empty((String)bodyStr)) {
                Map respMap = com.aliyun.teaxml.Client.parseXml((String)bodyStr, null);
                Map err = Common.assertAsMap(respMap.get("Error"));
                throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", err.get("Code")), new TeaPair("message", err.get("Message")), new TeaPair("data", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("statusCode", (Object)response.statusCode), new TeaPair("requestId", err.get("RequestId")), new TeaPair("hostId", err.get("HostId"))}))}));
            }
            Map headers = response.headers;
            String requestId = (String)headers.get("x-oss-request-id");
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)response.statusCode), new TeaPair("message", null), new TeaPair("data", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("statusCode", (Object)response.statusCode), new TeaPair("requestId", (Object)("" + requestId + ""))}))}));
        }
        Map ctx = attributeMap.key;
        if (!Common.isUnset((Object)ctx)) {
            if (!(Common.isUnset(ctx.get("crc")) || Common.isUnset(response.headers.get("x-oss-hash-crc64ecma")) || com.aliyun.darabonbastring.Client.equals((String)((String)ctx.get("crc")), (String)((String)response.headers.get("x-oss-hash-crc64ecma"))).booleanValue())) {
                throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"CrcNotMatched"), new TeaPair("data", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("clientCrc", ctx.get("crc")), new TeaPair("serverCrc", response.headers.get("x-oss-hash-crc64ecma"))}))}));
            }
            if (!(Common.isUnset(ctx.get("md5")) || Common.isUnset(response.headers.get("content-md5")) || com.aliyun.darabonbastring.Client.equals((String)((String)ctx.get("md5")), (String)((String)response.headers.get("content-md5"))).booleanValue())) {
                throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"MD5NotMatched"), new TeaPair("data", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("clientMD5", ctx.get("md5")), new TeaPair("serverMD5", response.headers.get("content-md5"))}))}));
            }
        }
        if (!Common.isUnset((Object)response.body)) {
            if (Common.equalNumber((Number)response.statusCode, (Number)204)) {
                Common.readAsString((InputStream)response.body);
            } else if (com.aliyun.darabonbastring.Client.equals((String)request.bodyType, (String)"xml").booleanValue()) {
                bodyStr = Common.readAsString((InputStream)response.body);
                Map result = com.aliyun.teaxml.Client.parseXml((String)bodyStr, null);
                List list = com.aliyun.darabonba.map.Client.keySet((Map)result);
                if (Common.equalNumber((Number)com.aliyun.darabonba.array.Client.size((List)list), (Number)1)) {
                    String tmp = (String)list.get(0);
                    try {
                        response.deserializedBody = Common.assertAsMap(result.get(tmp));
                    }
                    catch (TeaException error) {
                        response.deserializedBody = result;
                    }
                    catch (Exception _error) {
                        TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
                        response.deserializedBody = result;
                    }
                } else {
                    response.deserializedBody = result;
                }
            } else if (Common.equalString((String)request.bodyType, (String)"binary")) {
                response.deserializedBody = response.body;
            } else if (Common.equalString((String)request.bodyType, (String)"byte")) {
                byte[] byt = Common.readAsBytes((InputStream)response.body);
                response.deserializedBody = byt;
            } else if (Common.equalString((String)request.bodyType, (String)"string")) {
                response.deserializedBody = Common.readAsString((InputStream)response.body);
            } else if (Common.equalString((String)request.bodyType, (String)"json")) {
                Object obj = Common.readAsJSON((InputStream)response.body);
                Map res = Common.assertAsMap((Object)obj);
                response.deserializedBody = res;
            } else {
                response.deserializedBody = Common.equalString((String)request.bodyType, (String)"array") ? Common.readAsJSON((InputStream)response.body) : Common.readAsString((InputStream)response.body);
            }
        }
    }

    public String getEndpoint(String regionId, String network, String endpoint) throws Exception {
        if (!Common.empty((String)endpoint)) {
            return endpoint;
        }
        if (Common.empty((String)regionId)) {
            regionId = "cn-hangzhou";
        }
        if (!Common.empty((String)network)) {
            if (com.aliyun.darabonbastring.Client.contains((String)network, (String)"internal").booleanValue()) {
                return "oss-" + regionId + "-internal.aliyuncs.com";
            }
            if (com.aliyun.darabonbastring.Client.contains((String)network, (String)"ipv6").booleanValue()) {
                return "" + regionId + "oss.aliyuncs.com";
            }
            if (com.aliyun.darabonbastring.Client.contains((String)network, (String)"accelerate").booleanValue()) {
                return "oss-" + network + ".aliyuncs.com";
            }
        }
        return "oss-" + regionId + ".aliyuncs.com";
    }

    public String getHost(String endpointType, String bucketName, String endpoint) throws Exception {
        if (Common.empty((String)bucketName)) {
            return endpoint;
        }
        String host = "" + bucketName + "." + endpoint + "";
        if (!Common.empty((String)endpointType)) {
            if (com.aliyun.darabonbastring.Client.equals((String)endpointType, (String)"ip").booleanValue()) {
                host = "" + endpoint + "/" + bucketName + "";
            } else if (com.aliyun.darabonbastring.Client.equals((String)endpointType, (String)"cname").booleanValue()) {
                host = endpoint;
            }
        }
        return host;
    }

    public String getAuthorization(String signatureVersion, String bucketName, String pathname, String method, Map<String, String> query, Map<String, String> headers, String ak, String secret) throws Exception {
        String sign = "";
        if (Common.isUnset((Object)signatureVersion) || com.aliyun.darabonbastring.Client.equals((String)signatureVersion, (String)"v1").booleanValue()) {
            sign = this.getSignatureV1(bucketName, pathname, method, query, headers, secret);
            return "OSS " + ak + ":" + sign + "";
        }
        sign = this.getSignatureV2(bucketName, pathname, method, query, headers, secret);
        return "OSS2 AccessKeyId:" + ak + ",Signature:" + sign + "";
    }

    public String getSignatureV1(String bucketName, String pathname, String method, Map<String, String> query, Map<String, String> headers, String secret) throws Exception {
        String resource = "";
        String stringToSign = "";
        if (!Common.empty((String)bucketName)) {
            resource = "/" + bucketName + "";
        }
        resource = "" + resource + "" + pathname + "";
        String canonicalizedResource = this.buildCanonicalizedResource(resource, query);
        String canonicalizedHeaders = this.buildCanonicalizedHeaders(headers);
        stringToSign = "" + method + "\n" + canonicalizedHeaders + "" + canonicalizedResource + "";
        return Encoder.base64EncodeToString((byte[])Signer.HmacSHA1Sign((String)stringToSign, (String)secret));
    }

    public String buildCanonicalizedResource(String pathname, Map<String, String> query) throws Exception {
        List subResourcesArray;
        HashMap<String, String> subResourcesMap = new HashMap<String, String>();
        String canonicalizedResource = pathname;
        if (!Common.empty((String)pathname)) {
            List paths = com.aliyun.darabonbastring.Client.split((String)pathname, (String)"?", (Integer)2);
            canonicalizedResource = (String)paths.get(0);
            if (Common.equalNumber((Number)com.aliyun.darabonba.array.Client.size((List)paths), (Number)2)) {
                List subResources = com.aliyun.darabonbastring.Client.split((String)((String)paths.get(1)), (String)"&", null);
                for (String sub : subResources) {
                    Boolean hasExcepts = false;
                    for (String excepts : this._except_signed_params) {
                        if (!com.aliyun.darabonbastring.Client.contains((String)sub, (String)excepts).booleanValue()) continue;
                        hasExcepts = true;
                    }
                    if (hasExcepts.booleanValue()) continue;
                    List item = com.aliyun.darabonbastring.Client.split((String)sub, (String)"=", null);
                    String key = (String)item.get(0);
                    String value = null;
                    if (Common.equalNumber((Number)com.aliyun.darabonba.array.Client.size((List)item), (Number)2)) {
                        value = (String)item.get(1);
                    }
                    subResourcesMap.put(key, value);
                }
            }
        }
        List newQueryList = subResourcesArray = com.aliyun.darabonba.map.Client.keySet(subResourcesMap);
        if (!Common.isUnset(query)) {
            List queryList = com.aliyun.darabonba.map.Client.keySet(query);
            newQueryList = com.aliyun.darabonba.array.Client.concat((List)queryList, (List)subResourcesArray);
        }
        List sortedParams = com.aliyun.darabonba.array.Client.ascSort((List)newQueryList);
        String separator = "?";
        for (String paramName : sortedParams) {
            if (com.aliyun.darabonba.array.Client.contains(this._default_signed_params, (String)paramName).booleanValue()) {
                canonicalizedResource = "" + canonicalizedResource + "" + separator + "" + paramName + "";
                if (!Common.isUnset(query) && !Common.isUnset((Object)query.get(paramName))) {
                    canonicalizedResource = "" + canonicalizedResource + "=" + query.get(paramName) + "";
                } else if (!Common.isUnset(subResourcesMap.get(paramName))) {
                    canonicalizedResource = "" + canonicalizedResource + "=" + (String)subResourcesMap.get(paramName) + "";
                }
            } else if (com.aliyun.darabonba.array.Client.contains((List)subResourcesArray, (String)paramName).booleanValue()) {
                canonicalizedResource = "" + canonicalizedResource + "" + separator + "" + paramName + "";
                if (!Common.isUnset(subResourcesMap.get(paramName))) {
                    canonicalizedResource = "" + canonicalizedResource + "=" + (String)subResourcesMap.get(paramName) + "";
                }
            }
            separator = "&";
        }
        return canonicalizedResource;
    }

    public String buildCanonicalizedHeaders(Map<String, String> headers) throws Exception {
        String contentMd5;
        String canonicalizedHeaders = "";
        String contentType = headers.get("content-type");
        if (Common.isUnset((Object)contentType)) {
            contentType = "";
        }
        if (Common.isUnset((Object)(contentMd5 = headers.get("content-md5")))) {
            contentMd5 = "";
        }
        canonicalizedHeaders = "" + canonicalizedHeaders + "" + contentMd5 + "\n" + contentType + "\n" + headers.get("date") + "\n";
        List keys = com.aliyun.darabonba.map.Client.keySet(headers);
        List sortedHeaders = com.aliyun.darabonba.array.Client.ascSort((List)keys);
        for (String header : sortedHeaders) {
            if (!com.aliyun.darabonbastring.Client.contains((String)com.aliyun.darabonbastring.Client.toLower((String)header), (String)"x-oss-").booleanValue() || Common.isUnset((Object)headers.get(header))) continue;
            canonicalizedHeaders = "" + canonicalizedHeaders + "" + header + ":" + headers.get(header) + "\n";
        }
        return canonicalizedHeaders;
    }

    public String getSignatureV2(String bucketName, String pathname, String method, Map<String, String> query, Map<String, String> headers, String secret) throws Exception {
        return "";
    }
}

