/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class AsymmetricDecryptRequest
extends Request {
    @Query
    @NameInMap(value="Algorithm")
    @Validation(required=true)
    private String algorithm;
    @Query
    @NameInMap(value="CiphertextBlob")
    @Validation(required=true)
    private String ciphertextBlob;
    @Query
    @NameInMap(value="DryRun")
    private String dryRun;
    @Query
    @NameInMap(value="KeyId")
    @Validation(required=true)
    private String keyId;
    @Query
    @NameInMap(value="KeyVersionId")
    @Validation(required=true)
    private String keyVersionId;

    private AsymmetricDecryptRequest(Builder builder) {
        super((Request.Builder)builder);
        this.algorithm = builder.algorithm;
        this.ciphertextBlob = builder.ciphertextBlob;
        this.dryRun = builder.dryRun;
        this.keyId = builder.keyId;
        this.keyVersionId = builder.keyVersionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AsymmetricDecryptRequest create() {
        return AsymmetricDecryptRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCiphertextBlob() {
        return this.ciphertextBlob;
    }

    public String getDryRun() {
        return this.dryRun;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public static final class Builder
    extends Request.Builder<AsymmetricDecryptRequest, Builder> {
        private String algorithm;
        private String ciphertextBlob;
        private String dryRun;
        private String keyId;
        private String keyVersionId;

        private Builder() {
        }

        private Builder(AsymmetricDecryptRequest request) {
            super((Request)request);
            this.algorithm = request.algorithm;
            this.ciphertextBlob = request.ciphertextBlob;
            this.dryRun = request.dryRun;
            this.keyId = request.keyId;
            this.keyVersionId = request.keyVersionId;
        }

        public Builder algorithm(String algorithm) {
            this.putQueryParameter("Algorithm", algorithm);
            this.algorithm = algorithm;
            return this;
        }

        public Builder ciphertextBlob(String ciphertextBlob) {
            this.putQueryParameter("CiphertextBlob", ciphertextBlob);
            this.ciphertextBlob = ciphertextBlob;
            return this;
        }

        public Builder dryRun(String dryRun) {
            this.putQueryParameter("DryRun", dryRun);
            this.dryRun = dryRun;
            return this;
        }

        public Builder keyId(String keyId) {
            this.putQueryParameter("KeyId", keyId);
            this.keyId = keyId;
            return this;
        }

        public Builder keyVersionId(String keyVersionId) {
            this.putQueryParameter("KeyVersionId", keyVersionId);
            this.keyVersionId = keyVersionId;
            return this;
        }

        public AsymmetricDecryptRequest build() {
            return new AsymmetricDecryptRequest(this);
        }
    }
}

