/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CertificatePrivateKeyDecryptRequest
extends Request {
    @Query
    @NameInMap(value="Algorithm")
    @Validation(required=true)
    private String algorithm;
    @Query
    @NameInMap(value="CertificateId")
    @Validation(required=true)
    private String certificateId;
    @Query
    @NameInMap(value="CiphertextBlob")
    @Validation(required=true)
    private String ciphertextBlob;

    private CertificatePrivateKeyDecryptRequest(Builder builder) {
        super((Request.Builder)builder);
        this.algorithm = builder.algorithm;
        this.certificateId = builder.certificateId;
        this.ciphertextBlob = builder.ciphertextBlob;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CertificatePrivateKeyDecryptRequest create() {
        return CertificatePrivateKeyDecryptRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public String getCiphertextBlob() {
        return this.ciphertextBlob;
    }

    public static final class Builder
    extends Request.Builder<CertificatePrivateKeyDecryptRequest, Builder> {
        private String algorithm;
        private String certificateId;
        private String ciphertextBlob;

        private Builder() {
        }

        private Builder(CertificatePrivateKeyDecryptRequest request) {
            super((Request)request);
            this.algorithm = request.algorithm;
            this.certificateId = request.certificateId;
            this.ciphertextBlob = request.ciphertextBlob;
        }

        public Builder algorithm(String algorithm) {
            this.putQueryParameter("Algorithm", algorithm);
            this.algorithm = algorithm;
            return this;
        }

        public Builder certificateId(String certificateId) {
            this.putQueryParameter("CertificateId", certificateId);
            this.certificateId = certificateId;
            return this;
        }

        public Builder ciphertextBlob(String ciphertextBlob) {
            this.putQueryParameter("CiphertextBlob", ciphertextBlob);
            this.ciphertextBlob = ciphertextBlob;
            return this;
        }

        public CertificatePrivateKeyDecryptRequest build() {
            return new CertificatePrivateKeyDecryptRequest(this);
        }
    }
}

