/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class CreateCertificateRequest
extends Request {
    @Query
    @NameInMap(value="ExportablePrivateKey")
    private Boolean exportablePrivateKey;
    @Query
    @NameInMap(value="KeySpec")
    @Validation(required=true)
    private String keySpec;
    @Query
    @NameInMap(value="Subject")
    @Validation(required=true)
    private String subject;
    @Query
    @NameInMap(value="SubjectAlternativeNames")
    private Map<String, ?> subjectAlternativeNames;

    private CreateCertificateRequest(Builder builder) {
        super((Request.Builder)builder);
        this.exportablePrivateKey = builder.exportablePrivateKey;
        this.keySpec = builder.keySpec;
        this.subject = builder.subject;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateCertificateRequest create() {
        return CreateCertificateRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Boolean getExportablePrivateKey() {
        return this.exportablePrivateKey;
    }

    public String getKeySpec() {
        return this.keySpec;
    }

    public String getSubject() {
        return this.subject;
    }

    public Map<String, ?> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public static final class Builder
    extends Request.Builder<CreateCertificateRequest, Builder> {
        private Boolean exportablePrivateKey;
        private String keySpec;
        private String subject;
        private Map<String, ?> subjectAlternativeNames;

        private Builder() {
        }

        private Builder(CreateCertificateRequest request) {
            super((Request)request);
            this.exportablePrivateKey = request.exportablePrivateKey;
            this.keySpec = request.keySpec;
            this.subject = request.subject;
            this.subjectAlternativeNames = request.subjectAlternativeNames;
        }

        public Builder exportablePrivateKey(Boolean exportablePrivateKey) {
            this.putQueryParameter("ExportablePrivateKey", exportablePrivateKey);
            this.exportablePrivateKey = exportablePrivateKey;
            return this;
        }

        public Builder keySpec(String keySpec) {
            this.putQueryParameter("KeySpec", keySpec);
            this.keySpec = keySpec;
            return this;
        }

        public Builder subject(String subject) {
            this.putQueryParameter("Subject", subject);
            this.subject = subject;
            return this;
        }

        public Builder subjectAlternativeNames(Map<String, ?> subjectAlternativeNames) {
            String subjectAlternativeNamesShrink = this.shrink(subjectAlternativeNames, "SubjectAlternativeNames", "json");
            this.putQueryParameter("SubjectAlternativeNames", subjectAlternativeNamesShrink);
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        public CreateCertificateRequest build() {
            return new CreateCertificateRequest(this);
        }
    }
}

