/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreatePolicyRequest
extends Request {
    @Query
    @NameInMap(value="AccessControlRules")
    private String accessControlRules;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="KmsInstance")
    private String kmsInstance;
    @Query
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;
    @Query
    @NameInMap(value="Permissions")
    @Validation(required=true)
    private String permissions;
    @Query
    @NameInMap(value="Resources")
    @Validation(required=true)
    private String resources;

    private CreatePolicyRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessControlRules = builder.accessControlRules;
        this.description = builder.description;
        this.kmsInstance = builder.kmsInstance;
        this.name = builder.name;
        this.permissions = builder.permissions;
        this.resources = builder.resources;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreatePolicyRequest create() {
        return CreatePolicyRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessControlRules() {
        return this.accessControlRules;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKmsInstance() {
        return this.kmsInstance;
    }

    public String getName() {
        return this.name;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public String getResources() {
        return this.resources;
    }

    public static final class Builder
    extends Request.Builder<CreatePolicyRequest, Builder> {
        private String accessControlRules;
        private String description;
        private String kmsInstance;
        private String name;
        private String permissions;
        private String resources;

        private Builder() {
        }

        private Builder(CreatePolicyRequest request) {
            super((Request)request);
            this.accessControlRules = request.accessControlRules;
            this.description = request.description;
            this.kmsInstance = request.kmsInstance;
            this.name = request.name;
            this.permissions = request.permissions;
            this.resources = request.resources;
        }

        public Builder accessControlRules(String accessControlRules) {
            this.putQueryParameter("AccessControlRules", accessControlRules);
            this.accessControlRules = accessControlRules;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder kmsInstance(String kmsInstance) {
            this.putQueryParameter("KmsInstance", kmsInstance);
            this.kmsInstance = kmsInstance;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder permissions(String permissions) {
            this.putQueryParameter("Permissions", permissions);
            this.permissions = permissions;
            return this;
        }

        public Builder resources(String resources) {
            this.putQueryParameter("Resources", resources);
            this.resources = resources;
            return this;
        }

        public CreatePolicyRequest build() {
            return new CreatePolicyRequest(this);
        }
    }
}

