/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class ExportDataKeyRequest
extends Request {
    @Query
    @NameInMap(value="CiphertextBlob")
    @Validation(required=true)
    private String ciphertextBlob;
    @Query
    @NameInMap(value="DryRun")
    private String dryRun;
    @Query
    @NameInMap(value="EncryptionContext")
    private Map<String, ?> encryptionContext;
    @Query
    @NameInMap(value="PublicKeyBlob")
    @Validation(required=true)
    private String publicKeyBlob;
    @Query
    @NameInMap(value="WrappingAlgorithm")
    @Validation(required=true)
    private String wrappingAlgorithm;
    @Query
    @NameInMap(value="WrappingKeySpec")
    @Validation(required=true)
    private String wrappingKeySpec;

    private ExportDataKeyRequest(Builder builder) {
        super((Request.Builder)builder);
        this.ciphertextBlob = builder.ciphertextBlob;
        this.dryRun = builder.dryRun;
        this.encryptionContext = builder.encryptionContext;
        this.publicKeyBlob = builder.publicKeyBlob;
        this.wrappingAlgorithm = builder.wrappingAlgorithm;
        this.wrappingKeySpec = builder.wrappingKeySpec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ExportDataKeyRequest create() {
        return ExportDataKeyRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCiphertextBlob() {
        return this.ciphertextBlob;
    }

    public String getDryRun() {
        return this.dryRun;
    }

    public Map<String, ?> getEncryptionContext() {
        return this.encryptionContext;
    }

    public String getPublicKeyBlob() {
        return this.publicKeyBlob;
    }

    public String getWrappingAlgorithm() {
        return this.wrappingAlgorithm;
    }

    public String getWrappingKeySpec() {
        return this.wrappingKeySpec;
    }

    public static final class Builder
    extends Request.Builder<ExportDataKeyRequest, Builder> {
        private String ciphertextBlob;
        private String dryRun;
        private Map<String, ?> encryptionContext;
        private String publicKeyBlob;
        private String wrappingAlgorithm;
        private String wrappingKeySpec;

        private Builder() {
        }

        private Builder(ExportDataKeyRequest request) {
            super((Request)request);
            this.ciphertextBlob = request.ciphertextBlob;
            this.dryRun = request.dryRun;
            this.encryptionContext = request.encryptionContext;
            this.publicKeyBlob = request.publicKeyBlob;
            this.wrappingAlgorithm = request.wrappingAlgorithm;
            this.wrappingKeySpec = request.wrappingKeySpec;
        }

        public Builder ciphertextBlob(String ciphertextBlob) {
            this.putQueryParameter("CiphertextBlob", ciphertextBlob);
            this.ciphertextBlob = ciphertextBlob;
            return this;
        }

        public Builder dryRun(String dryRun) {
            this.putQueryParameter("DryRun", dryRun);
            this.dryRun = dryRun;
            return this;
        }

        public Builder encryptionContext(Map<String, ?> encryptionContext) {
            String encryptionContextShrink = this.shrink(encryptionContext, "EncryptionContext", "json");
            this.putQueryParameter("EncryptionContext", encryptionContextShrink);
            this.encryptionContext = encryptionContext;
            return this;
        }

        public Builder publicKeyBlob(String publicKeyBlob) {
            this.putQueryParameter("PublicKeyBlob", publicKeyBlob);
            this.publicKeyBlob = publicKeyBlob;
            return this;
        }

        public Builder wrappingAlgorithm(String wrappingAlgorithm) {
            this.putQueryParameter("WrappingAlgorithm", wrappingAlgorithm);
            this.wrappingAlgorithm = wrappingAlgorithm;
            return this;
        }

        public Builder wrappingKeySpec(String wrappingKeySpec) {
            this.putQueryParameter("WrappingKeySpec", wrappingKeySpec);
            this.wrappingKeySpec = wrappingKeySpec;
            return this;
        }

        public ExportDataKeyRequest build() {
            return new ExportDataKeyRequest(this);
        }
    }
}

