/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class RotateSecretRequest
extends Request {
    @Query
    @NameInMap(value="SecretName")
    @Validation(required=true)
    private String secretName;
    @Query
    @NameInMap(value="VersionId")
    @Validation(required=true)
    private String versionId;

    private RotateSecretRequest(Builder builder) {
        super((Request.Builder)builder);
        this.secretName = builder.secretName;
        this.versionId = builder.versionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RotateSecretRequest create() {
        return RotateSecretRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getSecretName() {
        return this.secretName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public static final class Builder
    extends Request.Builder<RotateSecretRequest, Builder> {
        private String secretName;
        private String versionId;

        private Builder() {
        }

        private Builder(RotateSecretRequest request) {
            super((Request)request);
            this.secretName = request.secretName;
            this.versionId = request.versionId;
        }

        public Builder secretName(String secretName) {
            this.putQueryParameter("SecretName", secretName);
            this.secretName = secretName;
            return this;
        }

        public Builder versionId(String versionId) {
            this.putQueryParameter("VersionId", versionId);
            this.versionId = versionId;
            return this;
        }

        public RotateSecretRequest build() {
            return new RotateSecretRequest(this);
        }
    }
}

