/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UntagResourceRequest
extends Request {
    @Query
    @NameInMap(value="CertificateId")
    private String certificateId;
    @Query
    @NameInMap(value="KeyId")
    private String keyId;
    @Query
    @NameInMap(value="SecretName")
    private String secretName;
    @Query
    @NameInMap(value="TagKeys")
    @Validation(required=true)
    private String tagKeys;

    private UntagResourceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.certificateId = builder.certificateId;
        this.keyId = builder.keyId;
        this.secretName = builder.secretName;
        this.tagKeys = builder.tagKeys;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UntagResourceRequest create() {
        return UntagResourceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public String getTagKeys() {
        return this.tagKeys;
    }

    public static final class Builder
    extends Request.Builder<UntagResourceRequest, Builder> {
        private String certificateId;
        private String keyId;
        private String secretName;
        private String tagKeys;

        private Builder() {
        }

        private Builder(UntagResourceRequest request) {
            super((Request)request);
            this.certificateId = request.certificateId;
            this.keyId = request.keyId;
            this.secretName = request.secretName;
            this.tagKeys = request.tagKeys;
        }

        public Builder certificateId(String certificateId) {
            this.putQueryParameter("CertificateId", certificateId);
            this.certificateId = certificateId;
            return this;
        }

        public Builder keyId(String keyId) {
            this.putQueryParameter("KeyId", keyId);
            this.keyId = keyId;
            return this;
        }

        public Builder secretName(String secretName) {
            this.putQueryParameter("SecretName", secretName);
            this.secretName = secretName;
            return this;
        }

        public Builder tagKeys(String tagKeys) {
            this.putQueryParameter("TagKeys", tagKeys);
            this.tagKeys = tagKeys;
            return this;
        }

        public UntagResourceRequest build() {
            return new UntagResourceRequest(this);
        }
    }
}

