/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ocr_api20210707.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.io.InputStream;

public class RecognizeEduPaperCutRequest
extends Request {
    @Query
    @NameInMap(value="CutType")
    @Validation(required=true)
    private String cutType;
    @Query
    @NameInMap(value="ImageType")
    @Validation(required=true)
    private String imageType;
    @Query
    @NameInMap(value="Subject")
    private String subject;
    @Query
    @NameInMap(value="Url")
    @Validation(maxLength=2048)
    private String url;
    @Body
    @NameInMap(value="body")
    private InputStream body;

    private RecognizeEduPaperCutRequest(Builder builder) {
        super((Request.Builder)builder);
        this.cutType = builder.cutType;
        this.imageType = builder.imageType;
        this.subject = builder.subject;
        this.url = builder.url;
        this.body = builder.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RecognizeEduPaperCutRequest create() {
        return RecognizeEduPaperCutRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCutType() {
        return this.cutType;
    }

    public String getImageType() {
        return this.imageType;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getUrl() {
        return this.url;
    }

    public InputStream getBody() {
        return this.body;
    }

    public static final class Builder
    extends Request.Builder<RecognizeEduPaperCutRequest, Builder> {
        private String cutType;
        private String imageType;
        private String subject;
        private String url;
        private InputStream body;

        private Builder() {
        }

        private Builder(RecognizeEduPaperCutRequest request) {
            super((Request)request);
            this.cutType = request.cutType;
            this.imageType = request.imageType;
            this.subject = request.subject;
            this.url = request.url;
            this.body = request.body;
        }

        public Builder cutType(String cutType) {
            this.putQueryParameter("CutType", cutType);
            this.cutType = cutType;
            return this;
        }

        public Builder imageType(String imageType) {
            this.putQueryParameter("ImageType", imageType);
            this.imageType = imageType;
            return this;
        }

        public Builder subject(String subject) {
            this.putQueryParameter("Subject", subject);
            this.subject = subject;
            return this;
        }

        public Builder url(String url) {
            this.putQueryParameter("Url", url);
            this.url = url;
            return this;
        }

        public Builder body(InputStream body) {
            this.putBodyParameter("body", body);
            this.body = body;
            return this;
        }

        public RecognizeEduPaperCutRequest build() {
            return new RecognizeEduPaperCutRequest(this);
        }
    }
}

