/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.ObjectACL;
import com.aliyun.sdk.service.oss20190517.models.StorageClass;
import java.io.InputStream;
import java.util.Map;

public class AppendObjectRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Header
    @NameInMap(value="Cache-Control")
    private String cacheControl;
    @Header
    @NameInMap(value="Content-Disposition")
    private String contentDisposition;
    @Header
    @NameInMap(value="Content-Encoding")
    private String contentEncoding;
    @Header
    @NameInMap(value="Content-MD5")
    private String contentMD5;
    @Header
    @NameInMap(value="Expires")
    private String expires;
    @Body
    @NameInMap(value="body")
    private InputStream body;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="position")
    @Validation(required=true)
    private Long position;
    @Header
    @NameInMap(value="x-oss-meta-*")
    private Map<String, String> metaData;
    @Header
    @NameInMap(value="x-oss-object-acl")
    private String acl;
    @Header
    @NameInMap(value="x-oss-server-side-encryption")
    private String serverSideEncryption;
    @Header
    @NameInMap(value="x-oss-storage-class")
    private String storageClass;

    private AppendObjectRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentMD5 = builder.contentMD5;
        this.expires = builder.expires;
        this.body = builder.body;
        this.bucket = builder.bucket;
        this.position = builder.position;
        this.metaData = builder.metaData;
        this.acl = builder.acl;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.storageClass = builder.storageClass;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AppendObjectRequest create() {
        return AppendObjectRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public String getExpires() {
        return this.expires;
    }

    public InputStream getBody() {
        return this.body;
    }

    public String getBucket() {
        return this.bucket;
    }

    public Long getPosition() {
        return this.position;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public String getAcl() {
        return this.acl;
    }

    public String getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public static final class Builder
    extends Request.Builder<AppendObjectRequest, Builder> {
        private String key;
        private String cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentMD5;
        private String expires;
        private InputStream body;
        private String bucket;
        private Long position;
        private Map<String, String> metaData;
        private String acl;
        private String serverSideEncryption;
        private String storageClass;

        private Builder() {
        }

        private Builder(AppendObjectRequest request) {
            super((Request)request);
            this.key = request.key;
            this.cacheControl = request.cacheControl;
            this.contentDisposition = request.contentDisposition;
            this.contentEncoding = request.contentEncoding;
            this.contentMD5 = request.contentMD5;
            this.expires = request.expires;
            this.body = request.body;
            this.bucket = request.bucket;
            this.position = request.position;
            this.metaData = request.metaData;
            this.acl = request.acl;
            this.serverSideEncryption = request.serverSideEncryption;
            this.storageClass = request.storageClass;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder cacheControl(String cacheControl) {
            this.putHeaderParameter("Cache-Control", cacheControl);
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.putHeaderParameter("Content-Disposition", contentDisposition);
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.putHeaderParameter("Content-Encoding", contentEncoding);
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentMD5(String contentMD5) {
            this.putHeaderParameter("Content-MD5", contentMD5);
            this.contentMD5 = contentMD5;
            return this;
        }

        public Builder expires(String expires) {
            this.putHeaderParameter("Expires", expires);
            this.expires = expires;
            return this;
        }

        public Builder body(InputStream body) {
            this.putBodyParameter("body", body);
            this.body = body;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder position(Long position) {
            this.putQueryParameter("position", position);
            this.position = position;
            return this;
        }

        public Builder metaData(Map<String, String> metaData) {
            this.putHeaderParameter("x-oss-meta-*", metaData);
            this.metaData = metaData;
            return this;
        }

        public Builder acl(String acl) {
            this.putHeaderParameter("x-oss-object-acl", acl);
            this.acl = acl;
            return this;
        }

        public Builder acl(ObjectACL acl) {
            this.putHeaderParameter("x-oss-object-acl", acl.getValue());
            this.acl = acl.getValue();
            return this;
        }

        public Builder serverSideEncryption(String serverSideEncryption) {
            this.putHeaderParameter("x-oss-server-side-encryption", serverSideEncryption);
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public Builder storageClass(String storageClass) {
            this.putHeaderParameter("x-oss-storage-class", storageClass);
            this.storageClass = storageClass;
            return this;
        }

        public Builder storageClass(StorageClass storageClass) {
            this.putHeaderParameter("x-oss-storage-class", storageClass.getValue());
            this.storageClass = storageClass.getValue();
            return this;
        }

        public AppendObjectRequest build() {
            return new AppendObjectRequest(this);
        }
    }
}

