/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;

public class GetObjectRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Header
    @NameInMap(value="Accept-Encoding")
    private String acceptEncoding;
    @Header
    @NameInMap(value="If-Match")
    private String ifMatch;
    @Header
    @NameInMap(value="If-Modified-Since")
    private String ifModifiedSince;
    @Header
    @NameInMap(value="If-None-Match")
    private String ifNoneMatch;
    @Header
    @NameInMap(value="If-Unmodified-Since")
    private String ifUnmodifiedSince;
    @Header
    @NameInMap(value="Range")
    private String range;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="response-cache-control")
    private String responseCacheControl;
    @Query
    @NameInMap(value="response-content-disposition")
    private String responseContentDisposition;
    @Query
    @NameInMap(value="response-content-encoding")
    private String responseContentEncoding;
    @Query
    @NameInMap(value="response-content-language")
    private String responseContentLanguage;
    @Query
    @NameInMap(value="response-content-type")
    private String responseContentType;
    @Query
    @NameInMap(value="response-expires")
    private String responseExpires;

    private GetObjectRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.acceptEncoding = builder.acceptEncoding;
        this.ifMatch = builder.ifMatch;
        this.ifModifiedSince = builder.ifModifiedSince;
        this.ifNoneMatch = builder.ifNoneMatch;
        this.ifUnmodifiedSince = builder.ifUnmodifiedSince;
        this.range = builder.range;
        this.bucket = builder.bucket;
        this.responseCacheControl = builder.responseCacheControl;
        this.responseContentDisposition = builder.responseContentDisposition;
        this.responseContentEncoding = builder.responseContentEncoding;
        this.responseContentLanguage = builder.responseContentLanguage;
        this.responseContentType = builder.responseContentType;
        this.responseExpires = builder.responseExpires;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GetObjectRequest create() {
        return GetObjectRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getRange() {
        return this.range;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getResponseCacheControl() {
        return this.responseCacheControl;
    }

    public String getResponseContentDisposition() {
        return this.responseContentDisposition;
    }

    public String getResponseContentEncoding() {
        return this.responseContentEncoding;
    }

    public String getResponseContentLanguage() {
        return this.responseContentLanguage;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public String getResponseExpires() {
        return this.responseExpires;
    }

    public static final class Builder
    extends Request.Builder<GetObjectRequest, Builder> {
        private String key;
        private String acceptEncoding;
        private String ifMatch;
        private String ifModifiedSince;
        private String ifNoneMatch;
        private String ifUnmodifiedSince;
        private String range;
        private String bucket;
        private String responseCacheControl;
        private String responseContentDisposition;
        private String responseContentEncoding;
        private String responseContentLanguage;
        private String responseContentType;
        private String responseExpires;

        private Builder() {
        }

        private Builder(GetObjectRequest request) {
            super((Request)request);
            this.key = request.key;
            this.acceptEncoding = request.acceptEncoding;
            this.ifMatch = request.ifMatch;
            this.ifModifiedSince = request.ifModifiedSince;
            this.ifNoneMatch = request.ifNoneMatch;
            this.ifUnmodifiedSince = request.ifUnmodifiedSince;
            this.range = request.range;
            this.bucket = request.bucket;
            this.responseCacheControl = request.responseCacheControl;
            this.responseContentDisposition = request.responseContentDisposition;
            this.responseContentEncoding = request.responseContentEncoding;
            this.responseContentLanguage = request.responseContentLanguage;
            this.responseContentType = request.responseContentType;
            this.responseExpires = request.responseExpires;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder acceptEncoding(String acceptEncoding) {
            this.putHeaderParameter("Accept-Encoding", acceptEncoding);
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.putHeaderParameter("If-Match", ifMatch);
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifModifiedSince(String ifModifiedSince) {
            this.putHeaderParameter("If-Modified-Since", ifModifiedSince);
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.putHeaderParameter("If-None-Match", ifNoneMatch);
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.putHeaderParameter("If-Unmodified-Since", ifUnmodifiedSince);
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder range(String range) {
            this.putHeaderParameter("Range", range);
            this.range = range;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder responseCacheControl(String responseCacheControl) {
            this.putQueryParameter("response-cache-control", responseCacheControl);
            this.responseCacheControl = responseCacheControl;
            return this;
        }

        public Builder responseContentDisposition(String responseContentDisposition) {
            this.putQueryParameter("response-content-disposition", responseContentDisposition);
            this.responseContentDisposition = responseContentDisposition;
            return this;
        }

        public Builder responseContentEncoding(String responseContentEncoding) {
            this.putQueryParameter("response-content-encoding", responseContentEncoding);
            this.responseContentEncoding = responseContentEncoding;
            return this;
        }

        public Builder responseContentLanguage(String responseContentLanguage) {
            this.putQueryParameter("response-content-language", responseContentLanguage);
            this.responseContentLanguage = responseContentLanguage;
            return this;
        }

        public Builder responseContentType(String responseContentType) {
            this.putQueryParameter("response-content-type", responseContentType);
            this.responseContentType = responseContentType;
            return this;
        }

        public Builder responseExpires(String responseExpires) {
            this.putQueryParameter("response-expires", responseExpires);
            this.responseExpires = responseExpires;
            return this;
        }

        public GetObjectRequest build() {
            return new GetObjectRequest(this);
        }
    }
}

