/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;

public class HeadObjectRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Header
    @NameInMap(value="If-Match")
    private String ifMatch;
    @Header
    @NameInMap(value="If-Modified-Since")
    private String ifModifiedSince;
    @Header
    @NameInMap(value="If-None-Match")
    private String ifNoneMatch;
    @Header
    @NameInMap(value="If-Unmodified-Since")
    private String ifUnmodifiedSince;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="versionId")
    private String versionId;

    private HeadObjectRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.ifMatch = builder.ifMatch;
        this.ifModifiedSince = builder.ifModifiedSince;
        this.ifNoneMatch = builder.ifNoneMatch;
        this.ifUnmodifiedSince = builder.ifUnmodifiedSince;
        this.bucket = builder.bucket;
        this.versionId = builder.versionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HeadObjectRequest create() {
        return HeadObjectRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public static final class Builder
    extends Request.Builder<HeadObjectRequest, Builder> {
        private String key;
        private String ifMatch;
        private String ifModifiedSince;
        private String ifNoneMatch;
        private String ifUnmodifiedSince;
        private String bucket;
        private String versionId;

        private Builder() {
        }

        private Builder(HeadObjectRequest request) {
            super((Request)request);
            this.key = request.key;
            this.ifMatch = request.ifMatch;
            this.ifModifiedSince = request.ifModifiedSince;
            this.ifNoneMatch = request.ifNoneMatch;
            this.ifUnmodifiedSince = request.ifUnmodifiedSince;
            this.bucket = request.bucket;
            this.versionId = request.versionId;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.putHeaderParameter("If-Match", ifMatch);
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifModifiedSince(String ifModifiedSince) {
            this.putHeaderParameter("If-Modified-Since", ifModifiedSince);
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.putHeaderParameter("If-None-Match", ifNoneMatch);
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.putHeaderParameter("If-Unmodified-Since", ifUnmodifiedSince);
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder versionId(String versionId) {
            this.putQueryParameter("versionId", versionId);
            this.versionId = versionId;
            return this;
        }

        public HeadObjectRequest build() {
            return new HeadObjectRequest(this);
        }
    }
}

