/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.EncodeType;

public class ListMultipartUploadsRequest
extends Request {
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="delimiter")
    private String delimiter;
    @Query
    @NameInMap(value="encoding-type")
    private String encodingType;
    @Query
    @NameInMap(value="key-marker")
    private String keyMarker;
    @Query
    @NameInMap(value="max-uploads")
    private Long maxUploads;
    @Query
    @NameInMap(value="prefix")
    private String prefix;
    @Query
    @NameInMap(value="upload-id-marker")
    private String uploadIdMarker;

    private ListMultipartUploadsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.bucket = builder.bucket;
        this.delimiter = builder.delimiter;
        this.encodingType = builder.encodingType;
        this.keyMarker = builder.keyMarker;
        this.maxUploads = builder.maxUploads;
        this.prefix = builder.prefix;
        this.uploadIdMarker = builder.uploadIdMarker;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListMultipartUploadsRequest create() {
        return ListMultipartUploadsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public String getKeyMarker() {
        return this.keyMarker;
    }

    public Long getMaxUploads() {
        return this.maxUploads;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUploadIdMarker() {
        return this.uploadIdMarker;
    }

    public static final class Builder
    extends Request.Builder<ListMultipartUploadsRequest, Builder> {
        private String bucket;
        private String delimiter;
        private String encodingType;
        private String keyMarker;
        private Long maxUploads;
        private String prefix;
        private String uploadIdMarker;

        private Builder() {
        }

        private Builder(ListMultipartUploadsRequest request) {
            super((Request)request);
            this.bucket = request.bucket;
            this.delimiter = request.delimiter;
            this.encodingType = request.encodingType;
            this.keyMarker = request.keyMarker;
            this.maxUploads = request.maxUploads;
            this.prefix = request.prefix;
            this.uploadIdMarker = request.uploadIdMarker;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.putQueryParameter("delimiter", delimiter);
            this.delimiter = delimiter;
            return this;
        }

        public Builder encodingType(String encodingType) {
            this.putQueryParameter("encoding-type", encodingType);
            this.encodingType = encodingType;
            return this;
        }

        public Builder encodingType(EncodeType encodingType) {
            this.putQueryParameter("encoding-type", encodingType.getValue());
            this.encodingType = encodingType.getValue();
            return this;
        }

        public Builder keyMarker(String keyMarker) {
            this.putQueryParameter("key-marker", keyMarker);
            this.keyMarker = keyMarker;
            return this;
        }

        public Builder maxUploads(Long maxUploads) {
            this.putQueryParameter("max-uploads", maxUploads);
            this.maxUploads = maxUploads;
            return this;
        }

        public Builder prefix(String prefix) {
            this.putQueryParameter("prefix", prefix);
            this.prefix = prefix;
            return this;
        }

        public Builder uploadIdMarker(String uploadIdMarker) {
            this.putQueryParameter("upload-id-marker", uploadIdMarker);
            this.uploadIdMarker = uploadIdMarker;
            return this;
        }

        public ListMultipartUploadsRequest build() {
            return new ListMultipartUploadsRequest(this);
        }
    }
}

