/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.EncodeType;

public class ListObjectsV2Request
extends Request {
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="continuation-token")
    private String continuationToken;
    @Query
    @NameInMap(value="delimiter")
    private String delimiter;
    @Query
    @NameInMap(value="encoding-type")
    private String encodingType;
    @Query
    @NameInMap(value="fetch-owner")
    private Boolean fetchOwner;
    @Query
    @NameInMap(value="max-keys")
    private Long maxKeys;
    @Query
    @NameInMap(value="prefix")
    private String prefix;
    @Query
    @NameInMap(value="start-after")
    private String startAfter;

    private ListObjectsV2Request(Builder builder) {
        super((Request.Builder)builder);
        this.bucket = builder.bucket;
        this.continuationToken = builder.continuationToken;
        this.delimiter = builder.delimiter;
        this.encodingType = builder.encodingType;
        this.fetchOwner = builder.fetchOwner;
        this.maxKeys = builder.maxKeys;
        this.prefix = builder.prefix;
        this.startAfter = builder.startAfter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListObjectsV2Request create() {
        return ListObjectsV2Request.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public Boolean getFetchOwner() {
        return this.fetchOwner;
    }

    public Long getMaxKeys() {
        return this.maxKeys;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getStartAfter() {
        return this.startAfter;
    }

    public static final class Builder
    extends Request.Builder<ListObjectsV2Request, Builder> {
        private String bucket;
        private String continuationToken;
        private String delimiter;
        private String encodingType;
        private Boolean fetchOwner;
        private Long maxKeys;
        private String prefix;
        private String startAfter;

        private Builder() {
        }

        private Builder(ListObjectsV2Request request) {
            super((Request)request);
            this.bucket = request.bucket;
            this.continuationToken = request.continuationToken;
            this.delimiter = request.delimiter;
            this.encodingType = request.encodingType;
            this.fetchOwner = request.fetchOwner;
            this.maxKeys = request.maxKeys;
            this.prefix = request.prefix;
            this.startAfter = request.startAfter;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder continuationToken(String continuationToken) {
            this.putQueryParameter("continuation-token", continuationToken);
            this.continuationToken = continuationToken;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.putQueryParameter("delimiter", delimiter);
            this.delimiter = delimiter;
            return this;
        }

        public Builder encodingType(String encodingType) {
            this.putQueryParameter("encoding-type", encodingType);
            this.encodingType = encodingType;
            return this;
        }

        public Builder encodingType(EncodeType encodingType) {
            this.putQueryParameter("encoding-type", encodingType.getValue());
            this.encodingType = encodingType.getValue();
            return this;
        }

        public Builder fetchOwner(Boolean fetchOwner) {
            this.putQueryParameter("fetch-owner", fetchOwner);
            this.fetchOwner = fetchOwner;
            return this;
        }

        public Builder maxKeys(Long maxKeys) {
            this.putQueryParameter("max-keys", maxKeys);
            this.maxKeys = maxKeys;
            return this;
        }

        public Builder prefix(String prefix) {
            this.putQueryParameter("prefix", prefix);
            this.prefix = prefix;
            return this;
        }

        public Builder startAfter(String startAfter) {
            this.putQueryParameter("start-after", startAfter);
            this.startAfter = startAfter;
            return this;
        }

        public ListObjectsV2Request build() {
            return new ListObjectsV2Request(this);
        }
    }
}

