/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.EncodeType;

public class ListPartsRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="encoding-type")
    private String encodingType;
    @Query
    @NameInMap(value="max-parts")
    private Long maxParts;
    @Query
    @NameInMap(value="part-number-marker")
    private Long partNumberMarker;
    @Query
    @NameInMap(value="uploadId")
    @Validation(required=true)
    private String uploadId;

    private ListPartsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.bucket = builder.bucket;
        this.encodingType = builder.encodingType;
        this.maxParts = builder.maxParts;
        this.partNumberMarker = builder.partNumberMarker;
        this.uploadId = builder.uploadId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListPartsRequest create() {
        return ListPartsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public Long getMaxParts() {
        return this.maxParts;
    }

    public Long getPartNumberMarker() {
        return this.partNumberMarker;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public static final class Builder
    extends Request.Builder<ListPartsRequest, Builder> {
        private String key;
        private String bucket;
        private String encodingType;
        private Long maxParts;
        private Long partNumberMarker;
        private String uploadId;

        private Builder() {
        }

        private Builder(ListPartsRequest request) {
            super((Request)request);
            this.key = request.key;
            this.bucket = request.bucket;
            this.encodingType = request.encodingType;
            this.maxParts = request.maxParts;
            this.partNumberMarker = request.partNumberMarker;
            this.uploadId = request.uploadId;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder encodingType(String encodingType) {
            this.putQueryParameter("encoding-type", encodingType);
            this.encodingType = encodingType;
            return this;
        }

        public Builder encodingType(EncodeType encodingType) {
            this.putQueryParameter("encoding-type", encodingType.getValue());
            this.encodingType = encodingType.getValue();
            return this;
        }

        public Builder maxParts(Long maxParts) {
            this.putQueryParameter("max-parts", maxParts);
            this.maxParts = maxParts;
            return this;
        }

        public Builder partNumberMarker(Long partNumberMarker) {
            this.putQueryParameter("part-number-marker", partNumberMarker);
            this.partNumberMarker = partNumberMarker;
            return this;
        }

        public Builder uploadId(String uploadId) {
            this.putQueryParameter("uploadId", uploadId);
            this.uploadId = uploadId;
            return this;
        }

        public ListPartsRequest build() {
            return new ListPartsRequest(this);
        }
    }
}

