/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;

public class OptionObjectRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Header
    @NameInMap(value="Access-Control-Request-Headers")
    private String accessControlRequestHeaders;
    @Header
    @NameInMap(value="Access-Control-Request-Method")
    private String accessControlRequestMethod;
    @Header
    @NameInMap(value="Origin")
    private String origin;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;

    private OptionObjectRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.accessControlRequestHeaders = builder.accessControlRequestHeaders;
        this.accessControlRequestMethod = builder.accessControlRequestMethod;
        this.origin = builder.origin;
        this.bucket = builder.bucket;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OptionObjectRequest create() {
        return OptionObjectRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getAccessControlRequestHeaders() {
        return this.accessControlRequestHeaders;
    }

    public String getAccessControlRequestMethod() {
        return this.accessControlRequestMethod;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getBucket() {
        return this.bucket;
    }

    public static final class Builder
    extends Request.Builder<OptionObjectRequest, Builder> {
        private String key;
        private String accessControlRequestHeaders;
        private String accessControlRequestMethod;
        private String origin;
        private String bucket;

        private Builder() {
        }

        private Builder(OptionObjectRequest request) {
            super((Request)request);
            this.key = request.key;
            this.accessControlRequestHeaders = request.accessControlRequestHeaders;
            this.accessControlRequestMethod = request.accessControlRequestMethod;
            this.origin = request.origin;
            this.bucket = request.bucket;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder accessControlRequestHeaders(String accessControlRequestHeaders) {
            this.putHeaderParameter("Access-Control-Request-Headers", accessControlRequestHeaders);
            this.accessControlRequestHeaders = accessControlRequestHeaders;
            return this;
        }

        public Builder accessControlRequestMethod(String accessControlRequestMethod) {
            this.putHeaderParameter("Access-Control-Request-Method", accessControlRequestMethod);
            this.accessControlRequestMethod = accessControlRequestMethod;
            return this;
        }

        public Builder origin(String origin) {
            this.putHeaderParameter("Origin", origin);
            this.origin = origin;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public OptionObjectRequest build() {
            return new OptionObjectRequest(this);
        }
    }
}

