/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.BucketACL;

public class PutBucketAclRequest
extends Request {
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Header
    @NameInMap(value="x-oss-acl")
    @Validation(required=true)
    private String acl;

    private PutBucketAclRequest(Builder builder) {
        super((Request.Builder)builder);
        this.bucket = builder.bucket;
        this.acl = builder.acl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutBucketAclRequest create() {
        return PutBucketAclRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getAcl() {
        return this.acl;
    }

    public static final class Builder
    extends Request.Builder<PutBucketAclRequest, Builder> {
        private String bucket;
        private String acl;

        private Builder() {
        }

        private Builder(PutBucketAclRequest request) {
            super((Request)request);
            this.bucket = request.bucket;
            this.acl = request.acl;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder acl(String acl) {
            this.putHeaderParameter("x-oss-acl", acl);
            this.acl = acl;
            return this;
        }

        public Builder acl(BucketACL acl) {
            this.putHeaderParameter("x-oss-acl", acl.getValue());
            this.acl = acl.getValue();
            return this;
        }

        public PutBucketAclRequest build() {
            return new PutBucketAclRequest(this);
        }
    }
}

