/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.InventoryConfiguration;

public class PutBucketInventoryRequest
extends Request {
    @Body
    @NameInMap(value="InventoryConfiguration")
    @Validation(required=true)
    private InventoryConfiguration inventoryConfiguration;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="inventoryId")
    @Validation(required=true)
    private String inventoryId;

    private PutBucketInventoryRequest(Builder builder) {
        super((Request.Builder)builder);
        this.inventoryConfiguration = builder.inventoryConfiguration;
        this.bucket = builder.bucket;
        this.inventoryId = builder.inventoryId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutBucketInventoryRequest create() {
        return PutBucketInventoryRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public InventoryConfiguration getInventoryConfiguration() {
        return this.inventoryConfiguration;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getInventoryId() {
        return this.inventoryId;
    }

    public static final class Builder
    extends Request.Builder<PutBucketInventoryRequest, Builder> {
        private InventoryConfiguration inventoryConfiguration;
        private String bucket;
        private String inventoryId;

        private Builder() {
        }

        private Builder(PutBucketInventoryRequest request) {
            super((Request)request);
            this.inventoryConfiguration = request.inventoryConfiguration;
            this.bucket = request.bucket;
            this.inventoryId = request.inventoryId;
        }

        public Builder inventoryConfiguration(InventoryConfiguration inventoryConfiguration) {
            this.putBodyParameter("InventoryConfiguration", (Object)inventoryConfiguration);
            this.inventoryConfiguration = inventoryConfiguration;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder inventoryId(String inventoryId) {
            this.putQueryParameter("inventoryId", inventoryId);
            this.inventoryId = inventoryId;
            return this;
        }

        public PutBucketInventoryRequest build() {
            return new PutBucketInventoryRequest(this);
        }
    }
}

