/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.sdk.service.oss20190517.models.ReplicationDestination;
import com.aliyun.sdk.service.oss20190517.models.ReplicationPrefixSet;
import com.aliyun.sdk.service.oss20190517.models.ReplicationSourceSelectionCriteria;
import darabonba.core.TeaModel;

public class ReplicationRule
extends TeaModel {
    @NameInMap(value="Action")
    private String action;
    @NameInMap(value="Destination")
    private ReplicationDestination destination;
    @NameInMap(value="EncryptionConfiguration")
    private EncryptionConfiguration encryptionConfiguration;
    @NameInMap(value="HistoricalObjectReplication")
    private String historicalObjectReplication;
    @NameInMap(value="ID")
    private String id;
    @NameInMap(value="PrefixSet")
    private ReplicationPrefixSet prefixSet;
    @NameInMap(value="SourceSelectionCriteria")
    private ReplicationSourceSelectionCriteria sourceSelectionCriteria;
    @NameInMap(value="Status")
    private String status;
    @NameInMap(value="SyncRole")
    private String syncRole;

    private ReplicationRule(Builder builder) {
        this.action = builder.action;
        this.destination = builder.destination;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.historicalObjectReplication = builder.historicalObjectReplication;
        this.id = builder.id;
        this.prefixSet = builder.prefixSet;
        this.sourceSelectionCriteria = builder.sourceSelectionCriteria;
        this.status = builder.status;
        this.syncRole = builder.syncRole;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReplicationRule create() {
        return ReplicationRule.builder().build();
    }

    public String getAction() {
        return this.action;
    }

    public ReplicationDestination getDestination() {
        return this.destination;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public String getHistoricalObjectReplication() {
        return this.historicalObjectReplication;
    }

    public String getId() {
        return this.id;
    }

    public ReplicationPrefixSet getPrefixSet() {
        return this.prefixSet;
    }

    public ReplicationSourceSelectionCriteria getSourceSelectionCriteria() {
        return this.sourceSelectionCriteria;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSyncRole() {
        return this.syncRole;
    }

    public static class EncryptionConfiguration
    extends TeaModel {
        @NameInMap(value="ReplicaKmsKeyID")
        private String replicaKmsKeyID;

        private EncryptionConfiguration(Builder builder) {
            this.replicaKmsKeyID = builder.replicaKmsKeyID;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static EncryptionConfiguration create() {
            return EncryptionConfiguration.builder().build();
        }

        public String getReplicaKmsKeyID() {
            return this.replicaKmsKeyID;
        }

        public static final class Builder {
            private String replicaKmsKeyID;

            public Builder replicaKmsKeyID(String replicaKmsKeyID) {
                this.replicaKmsKeyID = replicaKmsKeyID;
                return this;
            }

            public EncryptionConfiguration build() {
                return new EncryptionConfiguration(this);
            }
        }
    }

    public static final class Builder {
        private String action;
        private ReplicationDestination destination;
        private EncryptionConfiguration encryptionConfiguration;
        private String historicalObjectReplication;
        private String id;
        private ReplicationPrefixSet prefixSet;
        private ReplicationSourceSelectionCriteria sourceSelectionCriteria;
        private String status;
        private String syncRole;

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder destination(ReplicationDestination destination) {
            this.destination = destination;
            return this;
        }

        public Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public Builder historicalObjectReplication(String historicalObjectReplication) {
            this.historicalObjectReplication = historicalObjectReplication;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder prefixSet(ReplicationPrefixSet prefixSet) {
            this.prefixSet = prefixSet;
            return this;
        }

        public Builder sourceSelectionCriteria(ReplicationSourceSelectionCriteria sourceSelectionCriteria) {
            this.sourceSelectionCriteria = sourceSelectionCriteria;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder syncRole(String syncRole) {
            this.syncRole = syncRole;
            return this;
        }

        public ReplicationRule build() {
            return new ReplicationRule(this);
        }
    }
}

