/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.RestoreRequest;

public class RestoreObjectRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Body
    @NameInMap(value="RestoreRequest")
    private RestoreRequest restoreRequest;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="versionId")
    private String versionId;

    private RestoreObjectRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.restoreRequest = builder.restoreRequest;
        this.bucket = builder.bucket;
        this.versionId = builder.versionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RestoreObjectRequest create() {
        return RestoreObjectRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public RestoreRequest getRestoreRequest() {
        return this.restoreRequest;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public static final class Builder
    extends Request.Builder<RestoreObjectRequest, Builder> {
        private String key;
        private RestoreRequest restoreRequest;
        private String bucket;
        private String versionId;

        private Builder() {
        }

        private Builder(RestoreObjectRequest request) {
            super((Request)request);
            this.key = request.key;
            this.restoreRequest = request.restoreRequest;
            this.bucket = request.bucket;
            this.versionId = request.versionId;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder restoreRequest(RestoreRequest restoreRequest) {
            this.putBodyParameter("RestoreRequest", (Object)restoreRequest);
            this.restoreRequest = restoreRequest;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder versionId(String versionId) {
            this.putQueryParameter("versionId", versionId);
            this.versionId = versionId;
            return this;
        }

        public RestoreObjectRequest build() {
            return new RestoreObjectRequest(this);
        }
    }
}

