/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.SelectRequest;

public class SelectObjectRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Body
    @NameInMap(value="SelectRequest")
    @Validation(required=true)
    private SelectRequest selectRequest;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;

    private SelectObjectRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.selectRequest = builder.selectRequest;
        this.bucket = builder.bucket;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SelectObjectRequest create() {
        return SelectObjectRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public SelectRequest getSelectRequest() {
        return this.selectRequest;
    }

    public String getBucket() {
        return this.bucket;
    }

    public static final class Builder
    extends Request.Builder<SelectObjectRequest, Builder> {
        private String key;
        private SelectRequest selectRequest;
        private String bucket;

        private Builder() {
        }

        private Builder(SelectObjectRequest request) {
            super((Request)request);
            this.key = request.key;
            this.selectRequest = request.selectRequest;
            this.bucket = request.bucket;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder selectRequest(SelectRequest selectRequest) {
            this.putBodyParameter("SelectRequest", (Object)selectRequest);
            this.selectRequest = selectRequest;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public SelectObjectRequest build() {
            return new SelectObjectRequest(this);
        }
    }
}

