/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.kms.secretsmanager.client.utils;

import com.aliyuncs.exceptions.ClientException;

public class BackoffUtils {
    private static final String REJECTED_THROTTLING = "Rejected.Throttling";
    private static final String SERVICE_UNAVAILABLE_TEMPORARY = "ServiceUnavailableTemporary";
    private static final String INTERNAL_FAILURE = "InternalFailure";

    private BackoffUtils() {
    }

    public static boolean judgeNeedBackoff(ClientException e) {
        return REJECTED_THROTTLING.equals(e.getErrCode()) || SERVICE_UNAVAILABLE_TEMPORARY.equals(e.getErrCode()) || INTERNAL_FAILURE.equals(e.getErrCode());
    }

    public static boolean judgeNeedRecoveryException(ClientException e) {
        return "SDK.ReadTimeout".equals(e.getErrCode()) || "SDK.ServerUnreachable".equals(e.getErrCode()) || BackoffUtils.judgeNeedBackoff(e);
    }
}

