/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.kms.secretsmanager.client.utils;

import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.kms.secretsmanager.client.model.CredentialsProperties;
import com.aliyuncs.kms.secretsmanager.client.model.DKmsConfig;
import com.aliyuncs.kms.secretsmanager.client.model.RegionInfo;
import com.aliyuncs.kms.secretsmanager.client.utils.ClientKeyUtils;
import com.aliyuncs.kms.secretsmanager.client.utils.ConfigUtils;
import com.aliyuncs.kms.secretsmanager.client.utils.CredentialsProviderUtils;
import com.aliyuncs.kms.secretsmanager.client.utils.TypeUtils;
import com.aliyuncs.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CredentialsPropertiesUtils {
    private static final Gson gson = new Gson();
    private static final Type dkmsInstancesType = new TypeToken<ArrayList<DKmsConfig>>(){}.getType();

    private CredentialsPropertiesUtils() {
    }

    public static CredentialsProperties loadCredentialsProperties(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            fileName = "secretsmanager.properties";
        }
        Properties properties = ConfigUtils.loadConfig(fileName);
        CredentialsProperties credentialsProperties = new CredentialsProperties();
        credentialsProperties.setSourceProperties(properties);
        if (properties != null && properties.size() > 0) {
            CredentialsPropertiesUtils.initDefaultConfig(credentialsProperties);
            CredentialsPropertiesUtils.initSecretsRegions(credentialsProperties);
            CredentialsPropertiesUtils.initCredentialsProvider(credentialsProperties);
            CredentialsPropertiesUtils.initSecretNames(properties, credentialsProperties);
            return credentialsProperties;
        }
        return null;
    }

    private static void initDefaultConfig(CredentialsProperties credentialsProperties) {
        credentialsProperties.setPrivateKeyPath(credentialsProperties.getSourceProperties().getProperty("client_key_private_key_path"));
        try {
            String password = ClientKeyUtils.getPassword(credentialsProperties.getSourceProperties(), "client_key_password_from_env_variable", "client_key_password_from_file_path");
            credentialsProperties.setPassword(password);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void checkConfigParamNull(String param, String paramName) {
        if (StringUtils.isEmpty((CharSequence)param)) {
            throw new IllegalArgumentException(String.format("credentials config missing required parameters[%s]", paramName));
        }
    }

    private static void initSecretNames(Properties properties, CredentialsProperties credentialsProperties) {
        ArrayList<String> secretNameList = new ArrayList<String>();
        String secretNames = properties.getProperty("secret_names");
        if (!StringUtils.isEmpty((CharSequence)secretNames)) {
            secretNameList.addAll(Arrays.asList(secretNames.split(",")));
        }
        credentialsProperties.setSecretNameList(secretNameList);
    }

    private static void initSecretsRegions(CredentialsProperties credentialsProperties) {
        ArrayList<RegionInfo> regionInfoList = new ArrayList<RegionInfo>();
        CredentialsPropertiesUtils.initDkmsInstances(regionInfoList, credentialsProperties);
        CredentialsPropertiesUtils.initKmsRegions(regionInfoList, credentialsProperties);
        credentialsProperties.setRegionInfoList(regionInfoList);
    }

    private static void initKmsRegions(List<RegionInfo> regionInfoList, CredentialsProperties credentialsProperties) {
        String regionIds = credentialsProperties.getSourceProperties().getProperty("cache_client_region_id");
        if (!StringUtils.isEmpty((CharSequence)regionIds)) {
            try {
                List list = (List)new Gson().fromJson(regionIds, new TypeToken<List<Map<String, Object>>>(){}.getType());
                for (Map map : list) {
                    RegionInfo regionInfo = new RegionInfo();
                    regionInfo.setEndpoint(TypeUtils.parseString(map.get("endpoint")));
                    regionInfo.setRegionId(TypeUtils.parseString(map.get("regionId")));
                    regionInfo.setVpc(TypeUtils.parseBoolean(map.get("vpc")));
                    regionInfoList.add(regionInfo);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("credentials config param[%s] is illegal", "cache_client_region_id"));
            }
        }
    }

    private static void initDkmsInstances(List<RegionInfo> regionInfoList, CredentialsProperties credentialsProperties) {
        List dKmsConfigs = new ArrayList();
        String configJson = credentialsProperties.getSourceProperties().getProperty("cache_client_dkms_config_info");
        if (!StringUtils.isEmpty((CharSequence)configJson)) {
            try {
                dKmsConfigs = (List)gson.fromJson(configJson, dkmsInstancesType);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("credentials config param[%s] is illegal", "cache_client_dkms_config_info"));
            }
        }
        HashMap<RegionInfo, DKmsConfig> dKmsConfigsMap = new HashMap<RegionInfo, DKmsConfig>();
        for (DKmsConfig dKmsConfig : dKmsConfigs) {
            RegionInfo regionInfo = new RegionInfo();
            if (StringUtils.isEmpty((CharSequence)dKmsConfig.getRegionId()) || StringUtils.isEmpty((CharSequence)dKmsConfig.getEndpoint())) {
                throw new IllegalArgumentException("init properties fail,cause of cache_client_dkms_config_info param[regionId or endpoint] is null");
            }
            regionInfo.setRegionId(dKmsConfig.getRegionId());
            regionInfo.setEndpoint(dKmsConfig.getEndpoint());
            regionInfo.setKmsType(1);
            try {
                if (!StringUtils.isEmpty((CharSequence)dKmsConfig.getPasswordFromFilePath())) {
                    dKmsConfig.setPassword(ClientKeyUtils.readPasswordFile(dKmsConfig.getPasswordFromFilePath()));
                } else {
                    dKmsConfig.setPassword(ClientKeyUtils.getPassword(credentialsProperties.getSourceProperties(), dKmsConfig.getPasswordFromEnvVariable(), dKmsConfig.getPasswordFromFilePathName()));
                }
            }
            catch (IllegalArgumentException e) {
                if (StringUtils.isEmpty((CharSequence)credentialsProperties.getPassword())) {
                    throw e;
                }
                dKmsConfig.setPassword(credentialsProperties.getPassword());
            }
            if (StringUtils.isEmpty((CharSequence)dKmsConfig.clientKeyFile) && StringUtils.isEmpty((CharSequence)credentialsProperties.getPrivateKeyPath())) {
                throw new IllegalArgumentException("client key file is not provided");
            }
            dKmsConfigsMap.put(regionInfo, dKmsConfig);
            regionInfoList.add(regionInfo);
        }
        credentialsProperties.setDkmsConfigsMap(dKmsConfigsMap);
    }

    private static void initCredentialsProvider(CredentialsProperties credentialsProperties) {
        String credentialsType = credentialsProperties.getSourceProperties().getProperty("credentials_type");
        String accessKeyId = credentialsProperties.getSourceProperties().getProperty("credentials_access_key_id");
        String accessSecret = credentialsProperties.getSourceProperties().getProperty("credentials_access_secret");
        if (!StringUtils.isEmpty((CharSequence)credentialsType)) {
            AlibabaCloudCredentialsProvider credentialsProvider;
            switch (credentialsType) {
                case "ak": {
                    CredentialsPropertiesUtils.checkConfigParamNull(accessKeyId, "credentials_access_key_id");
                    CredentialsPropertiesUtils.checkConfigParamNull(accessSecret, "credentials_access_secret");
                    credentialsProvider = CredentialsProviderUtils.withAccessKey(accessKeyId, accessSecret);
                    break;
                }
                case "token": {
                    String credentialsAccessTokenId = credentialsProperties.getSourceProperties().getProperty("credentials_access_token_id");
                    String credentialsAccessToken = credentialsProperties.getSourceProperties().getProperty("credentials_access_token");
                    CredentialsPropertiesUtils.checkConfigParamNull(credentialsAccessTokenId, "credentials_access_token_id");
                    CredentialsPropertiesUtils.checkConfigParamNull(credentialsAccessToken, "credentials_access_token");
                    credentialsProvider = CredentialsProviderUtils.withToken(credentialsAccessTokenId, credentialsAccessToken);
                    break;
                }
                case "sts": 
                case "ram_role": {
                    CredentialsPropertiesUtils.checkConfigParamNull(accessKeyId, "credentials_access_key_id");
                    CredentialsPropertiesUtils.checkConfigParamNull(accessSecret, "credentials_access_secret");
                    String roleSessionName = credentialsProperties.getSourceProperties().getProperty("credentials_role_session_name");
                    String roleArn = credentialsProperties.getSourceProperties().getProperty("credentials_role_arn");
                    String policy = credentialsProperties.getSourceProperties().getProperty("credentials_policy");
                    CredentialsPropertiesUtils.checkConfigParamNull(roleSessionName, "credentials_role_session_name");
                    CredentialsPropertiesUtils.checkConfigParamNull(roleArn, "credentials_role_arn");
                    credentialsProvider = CredentialsProviderUtils.withRamRoleArnOrSts(accessKeyId, accessSecret, credentialsProperties.getRegionInfoList().get(0).getRegionId(), roleSessionName, roleArn, policy);
                    break;
                }
                case "ecs_ram_role": {
                    String roleName = credentialsProperties.getSourceProperties().getProperty("credentials_role_name");
                    CredentialsPropertiesUtils.checkConfigParamNull(roleName, "credentials_role_name");
                    credentialsProvider = CredentialsProviderUtils.withEcsRamRole(roleName);
                    break;
                }
                case "client_key": {
                    String password = ClientKeyUtils.getPassword(credentialsProperties.getSourceProperties(), "client_key_password_from_env_variable", "client_key_password_from_file_path");
                    String privateKeyPath = credentialsProperties.getSourceProperties().getProperty("client_key_private_key_path");
                    CredentialsPropertiesUtils.checkConfigParamNull(privateKeyPath, "client_key_private_key_path");
                    credentialsProvider = CredentialsProviderUtils.getCredentialsProvider(privateKeyPath, password);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("credentials config param[%s] is illegal", "credentials_type"));
                }
            }
            credentialsProperties.setProvider(credentialsProvider);
        }
    }
}

