/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.http.HttpHeader;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.sdk.gateway.oss.internal.interceptor.AttributeKey;
import com.aliyun.sdk.gateway.oss.util.Mimetypes;
import darabonba.core.TeaRequest;
import darabonba.core.TeaRequestBody;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.RequestInterceptor;
import java.util.Arrays;
import java.util.List;

public class AddCommonHeadersInterceptor
implements RequestInterceptor {
    public static final List<String> DETECTED_BY_OBJECT_NAME_ACTIONS = Arrays.asList("PutObject", "AppendObject", "CopyObject", "InitiateMultipartUpload");

    public TeaRequest modifyRequest(InterceptorContext context, AttributeMap attributes) {
        TeaRequest request = context.teaRequest();
        AddCommonHeadersInterceptor.addContentMD5IfNeeded(request, attributes);
        AddCommonHeadersInterceptor.addContentTypeIfNeeded(request, attributes);
        AddCommonHeadersInterceptor.addUserAgentIfNeeded(request, context);
        return request;
    }

    private static void addContentMD5IfNeeded(TeaRequest request, AttributeMap attributes) {
        HttpHeader header = request.headers().get("Content-MD5");
        if (header == null && attributes.containsKey(AttributeKey.OSS_XML_BODY_CONTENT_MD5)) {
            String MD5 = (String)attributes.get(AttributeKey.OSS_XML_BODY_CONTENT_MD5);
            request.headers().set("Content-MD5", MD5);
        }
    }

    private static void addContentTypeIfNeeded(TeaRequest request, AttributeMap attributes) {
        String MIMETYPE_DEFAULT = "application/octet-stream";
        HttpHeader header = request.headers().get("Content-Type");
        if (header == null) {
            TeaRequestBody requestBody = (TeaRequestBody)attributes.get(AttributeKey.REQUEST_BODY);
            String contentType = requestBody.contentType().isPresent() ? (String)requestBody.contentType().get() : (!DETECTED_BY_OBJECT_NAME_ACTIONS.contains(request.action()) ? "application/octet-stream" : Mimetypes.getInstance().getMimetype(request.pathname()));
            request.headers().set("Content-Type", contentType);
        }
    }

    private static void addUserAgentIfNeeded(TeaRequest request, InterceptorContext context) {
        HttpHeader header = request.headers().get("User-Agent");
        if (header == null) {
            String ua = (String)context.configuration().clientConfiguration().option(ClientOption.USER_AGENT);
            request.headers().set("User-Agent", ua);
        }
    }
}

