/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.models;

import java.util.Map;
import java.util.Optional;

public class ResponseMetadata {
    private static final String UNKNOWN = "UNKNOWN";
    private static final String NEGATIVE_ONE = "-1";
    private final Map<String, String> metadata;

    public ResponseMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getRequestId() {
        return this.getValueAsString("x-oss-request-id");
    }

    public long getServerTime() {
        return this.getValueAsLong("x-oss-server-time");
    }

    private final String getValueAsString(String key) {
        try {
            return Optional.ofNullable(this.metadata.get(key)).orElse(UNKNOWN);
        }
        catch (Exception e) {
            return UNKNOWN;
        }
    }

    private long getValueAsLong(String key) {
        try {
            return Long.parseLong(Optional.ofNullable(this.metadata.get(key)).orElse(NEGATIVE_ONE));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long getValueAsInt(String key) {
        try {
            return Integer.parseInt(Optional.ofNullable(this.metadata.get(key)).orElse(NEGATIVE_ONE));
        }
        catch (Exception e) {
            return -1L;
        }
    }
}

