/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.auth.signer;

import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.signature.signer.SignAlgorithmHmacSHA1;
import com.aliyun.core.http.HttpHeader;
import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.utils.Base64Util;
import com.aliyun.sdk.gateway.oss.auth.signer.OSSSigner;
import com.aliyun.sdk.gateway.oss.auth.signer.OSSSignerParams;
import darabonba.core.TeaRequest;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OSSV1Signer
implements OSSSigner {
    private static final String OSS_PREFIX = "x-oss-";
    private static final String AUTHORIZATION = "Authorization";
    private static final String CONTENT_MD5 = "Content-MD5";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String DATE = "Date";
    private static final String NEW_LINE = "\n";
    private static final String AUTHORIZATION_PREFIX = "OSS ";
    private static final List<String> DEFAULT_SIGNED_PARAMETERS = Arrays.asList("response-cache-control", "response-content-disposition", "response-content-encoding", "response-content-language", "response-content-type", "response-expires", "continuation-token", "security-token", "callback", "callback-var", "versionId", "uploadId", "partNumber", "position", "sequential", "inventoryId", "wormId", "startTime", "endTime", "status");

    @Override
    public HttpRequest sign(TeaRequest request, HttpRequest httpRequest, OSSSignerParams params) {
        ICredential cred = params.credentials();
        String signature = OSSV1Signer.buildSignature(cred.accessKeySecret(), request.method().toString(), request.pathname(), httpRequest.getHeaders(), request.query(), params.subResources());
        httpRequest.getHeaders().set(AUTHORIZATION, OSSV1Signer.composeRequestAuthorization(cred.accessKeyId(), signature));
        return httpRequest;
    }

    @Override
    public TeaRequest presign(TeaRequest request, OSSSignerParams params) {
        Instant instant = params.SignatureExpiration();
        ICredential cred = params.credentials();
        String expires = String.valueOf(instant.toEpochMilli() / 1000L);
        HttpRequest httpRequest = new HttpRequest(request.method());
        httpRequest.getHeaders().putAll(request.headers());
        httpRequest.setHeader(DATE, expires);
        String signature = OSSV1Signer.buildSignature(cred.accessKeySecret(), request.method().toString(), request.pathname(), httpRequest.getHeaders(), request.query(), params.subResources());
        request.query().put("Expires", expires);
        request.query().put("OSSAccessKeyId", cred.accessKeyId());
        request.query().put("Signature", signature);
        return request;
    }

    private static String composeRequestAuthorization(String accessKeyId, String signature) {
        return AUTHORIZATION_PREFIX + accessKeyId + ":" + signature;
    }

    private static String buildCanonicalString(String method, String resourcePath, HttpHeaders headers, Map<String, String> query, List<String> subResources) {
        StringBuilder canonicalString = new StringBuilder();
        canonicalString.append(method).append(NEW_LINE);
        TreeMap<String, String> headersToSign = new TreeMap<String, String>();
        for (HttpHeader header : headers) {
            String lowerKey;
            if (header == null || !(lowerKey = header.getName().toLowerCase()).equals(CONTENT_TYPE.toLowerCase()) && !lowerKey.equals(CONTENT_MD5.toLowerCase()) && !lowerKey.equals(DATE.toLowerCase()) && !lowerKey.startsWith(OSS_PREFIX)) continue;
            headersToSign.put(lowerKey, header.getValue().trim());
        }
        if (!headersToSign.containsKey(CONTENT_TYPE.toLowerCase())) {
            headersToSign.put(CONTENT_TYPE.toLowerCase(), "");
        }
        if (!headersToSign.containsKey(CONTENT_MD5.toLowerCase())) {
            headersToSign.put(CONTENT_MD5.toLowerCase(), "");
        }
        for (Map.Entry entry : headersToSign.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.startsWith(OSS_PREFIX)) {
                canonicalString.append(key).append(':').append(value);
            } else {
                canonicalString.append(value);
            }
            canonicalString.append(NEW_LINE);
        }
        canonicalString.append(OSSV1Signer.buildCanonicalizedResource(resourcePath, query, subResources));
        return canonicalString.toString();
    }

    private static boolean hasSubResource(String name, List<String> subResources) {
        if (subResources.contains(name)) {
            return true;
        }
        if (DEFAULT_SIGNED_PARAMETERS.contains(name)) {
            return true;
        }
        return name.startsWith(OSS_PREFIX);
    }

    private static String buildCanonicalizedResource(String resourcePath, Map<String, String> parameters, List<String> subResources) {
        StringBuilder builder = new StringBuilder();
        builder.append(resourcePath);
        if (parameters != null) {
            Object[] parameterNames = parameters.keySet().toArray(new String[parameters.size()]);
            Arrays.sort(parameterNames);
            int separator = 63;
            for (Object paramName : parameterNames) {
                if (!OSSV1Signer.hasSubResource((String)paramName, subResources)) continue;
                builder.append((char)separator);
                builder.append((String)paramName);
                String paramValue = parameters.get(paramName);
                if (paramValue != null && !paramValue.isEmpty()) {
                    builder.append("=").append(paramValue);
                }
                separator = 38;
            }
        }
        return builder.toString();
    }

    private static String computeSignature(String key, String data) {
        byte[] signData = OSSV1Signer.sign(key.getBytes(StandardCharsets.UTF_8), data.getBytes(StandardCharsets.UTF_8));
        return Base64Util.encodeToString((byte[])signData);
    }

    private static byte[] sign(byte[] key, byte[] data) {
        try {
            Mac mac = SignAlgorithmHmacSHA1.HmacSHA1.getMac();
            mac.init(new SecretKeySpec(key, SignAlgorithmHmacSHA1.HmacSHA1.toString()));
            return mac.doFinal(data);
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException("Invalid key: " + key, ex);
        }
    }

    private static String buildSignature(String secretAccessKey, String httpMethod, String resourcePath, HttpHeaders headers, Map<String, String> query, List<String> subResources) {
        String canonicalString = OSSV1Signer.buildCanonicalString(httpMethod, resourcePath, headers, query, subResources);
        return OSSV1Signer.computeSignature(secretAccessKey, canonicalString);
    }
}

