/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.http.HttpMethod;
import com.aliyun.core.http.HttpResponseHandler;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.BaseUtils;
import com.aliyun.core.utils.XmlUtil;
import com.aliyun.sdk.gateway.oss.exception.OSSClientException;
import com.aliyun.sdk.gateway.oss.exception.OSSErrorDetails;
import com.aliyun.sdk.gateway.oss.exception.OSSServerException;
import com.aliyun.sdk.gateway.oss.internal.async.StoredSeparatelyHttpResponseHandler;
import darabonba.core.TeaRequest;
import darabonba.core.TeaResponse;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.ResponseInterceptor;
import darabonba.core.internal.AttributeKey;
import darabonba.core.utils.CommonUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.dom4j.DocumentException;

public class ProcResponseBodyInterceptor
implements ResponseInterceptor {
    private static final List<String> HEAD_OBJECT_ACTIONS = Arrays.asList("HeadObject", "GetObjectMeta");

    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        TeaResponse response = context.teaResponse();
        response = response.success() ? this.procSuccessResponse(context, attributes) : (this.hasNotResponseBody(context) ? this.procFailResponseWithoutBody(context, attributes) : this.procFailResponse(context, attributes));
        return response;
    }

    private Object toDeserializedBodyForNoneType(InterceptorContext context, AttributeMap attributes) {
        TeaResponse response = context.teaResponse();
        Class<?> type = null;
        try {
            type = context.output().getClass().getDeclaredField("body").getType();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (type == String.class) {
            return response.httpResponse().getBodyAsString();
        }
        if (type == InputStream.class) {
            return new ByteArrayInputStream(response.httpResponse().getBodyAsByteArray());
        }
        return response.httpResponse().getBodyAsByteArray();
    }

    private TeaResponse procSuccessResponse(InterceptorContext context, AttributeMap attributes) {
        TeaRequest request = context.teaRequest();
        TeaResponse response = context.teaResponse();
        if (this.skipDeserializeBody(context)) {
            return response;
        }
        OSSClientException exception = null;
        String bodyStr = "";
        try {
            switch (request.bodyType()) {
                case "xml": {
                    bodyStr = response.httpResponse().getBodyAsString();
                    response.setDeserializedBody(this.deserializeXMLBody(bodyStr));
                    break;
                }
                case "binary": {
                    response.setDeserializedBody((Object)new ByteArrayInputStream(response.httpResponse().getBodyAsByteArray()));
                    break;
                }
                case "none": {
                    response.setDeserializedBody(this.toDeserializedBodyForNoneType(context, attributes));
                    break;
                }
                default: {
                    bodyStr = response.httpResponse().getBodyAsString();
                    response.setDeserializedBody((Object)bodyStr);
                    break;
                }
            }
        }
        catch (Exception e) {
            exception = new OSSClientException("Parsing response body fail, the partial text is " + this.partialString(bodyStr), e);
        }
        response.setException((Exception)((Object)exception));
        return response;
    }

    private TeaResponse procFailResponse(InterceptorContext context, AttributeMap attributes) {
        TeaResponse response = context.teaResponse();
        OSSServerException exception = null;
        String bodyStr = "";
        String requestId = null;
        try {
            requestId = response.httpResponse().getHeaders().getValue("x-oss-request-id");
            bodyStr = this.readResponseErrorBody(response, attributes);
            Map<String, Object> body = this.deserializeXMLBody(bodyStr);
            OSSErrorDetails errorDetail = body.containsKey("Error") ? new OSSErrorDetails((HashMap)body.get("Error"), bodyStr) : this.buildFakeErrorDetails("InvalidResponseFormat", requestId, bodyStr);
            exception = new OSSServerException(response.httpResponse().getStatusCode(), errorDetail);
        }
        catch (Exception e) {
            exception = new OSSServerException(response.httpResponse().getStatusCode(), this.buildFakeErrorDetails("InvalidResponseFormat", requestId, bodyStr));
        }
        response.setException((Exception)((Object)exception));
        return response;
    }

    private TeaResponse procFailResponseWithoutBody(InterceptorContext context, AttributeMap attributes) {
        String action = context.teaRequest().action();
        TeaResponse response = context.teaResponse();
        String requestId = response.httpResponse().getHeaders().getValue("x-oss-request-id");
        int code = response.httpResponse().getStatusCode();
        String strCode = HEAD_OBJECT_ACTIONS.contains(action) && code == 404 ? "NoSuchKey" : "Server:" + code;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Code", strCode);
        map.put("Message", "");
        map.put("RequestId", Optional.ofNullable(requestId).orElse(""));
        OSSServerException exception = new OSSServerException(response.httpResponse().getStatusCode(), new OSSErrorDetails(map, ""));
        response.setException((Exception)((Object)exception));
        return response;
    }

    private boolean hasNotResponseBody(InterceptorContext context) {
        return context.teaRequest().method() == HttpMethod.HEAD;
    }

    private String readResponseErrorBody(TeaResponse response, AttributeMap attributes) {
        if (attributes.containsKey((AttributeMap.Key)AttributeKey.HTTP_RESPONSE_HANDLER)) {
            HttpResponseHandler handler = (HttpResponseHandler)attributes.get((AttributeMap.Key)AttributeKey.HTTP_RESPONSE_HANDLER);
            return BaseUtils.bomAwareToString((byte[])((StoredSeparatelyHttpResponseHandler)handler).getErrorBodyByteArrayUnsafe(), null);
        }
        return response.httpResponse().getBodyAsString();
    }

    private boolean skipDeserializeBody(InterceptorContext context) {
        return context.teaResponseHandler() != null;
    }

    private Map<String, Object> deserializeXMLBody(String data) throws DocumentException {
        Map body = XmlUtil.deserializeXml((String)data);
        return CommonUtil.assertAsMap(Optional.ofNullable(body).orElse(new HashMap()));
    }

    private String partialString(String value) {
        int len = value.length() > 128 ? 128 : value.length();
        return value.substring(0, len);
    }

    private OSSErrorDetails buildFakeErrorDetails(String code, String requestId, String body) {
        if (body == null) {
            body = "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String msg = "The response body is not well formed, the partial text is " + this.partialString(body);
        map.put("Code", code);
        map.put("Message", msg);
        map.put("RequestId", requestId);
        return new OSSErrorDetails(map, body);
    }
}

