/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.models;

import darabonba.core.RequestModel;
import darabonba.core.exception.ValidateException;
import java.io.UnsupportedEncodingException;

public abstract class Request
extends RequestModel {
    protected Request(Builder<?, ?> builder) {
        super(builder);
    }

    public void validate() {
        super.validate();
        Request.ensureBucketNameValidIfNotNull((String)this.getHostParameters().get("bucket"));
        Request.ensureObjectKeyValidIfNotNull((String)this.getPathParameters().get("key"));
    }

    private static boolean validateBucketName(String bucketName) {
        if (bucketName == null) {
            return false;
        }
        return bucketName.matches("^[a-z0-9][a-z0-9-_]{1,61}[a-z0-9]$");
    }

    private static void ensureBucketNameValidIfNotNull(String bucketName) {
        if (bucketName == null) {
            return;
        }
        if (!Request.validateBucketName(bucketName)) {
            throw new ValidateException("The bucket name " + bucketName + " is invalid.");
        }
    }

    private static boolean validateObjectKey(String key) {
        byte[] bytes;
        if (key == null || key.length() == 0) {
            return true;
        }
        try {
            bytes = key.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return true;
        }
        char[] keyChars = key.toCharArray();
        char firstChar = keyChars[0];
        if (firstChar == '\\') {
            return true;
        }
        return bytes.length <= 0 || bytes.length >= 1024;
    }

    private static void ensureObjectKeyValidIfNotNull(String key) {
        if (key == null) {
            return;
        }
        if (Request.validateObjectKey(key)) {
            throw new ValidateException("The object name " + key + " is invalid.");
        }
    }

    public abstract Builder toBuilder();

    protected static abstract class Builder<ProviderT extends Request, BuilderT extends Builder>
    extends RequestModel.BuilderImpl<ProviderT, BuilderT> {
        protected Builder() {
        }

        protected Builder(Request request) {
        }

        public BuilderT headerParam(String name, Object value) {
            this.putHeaderParameter(name, value);
            return (BuilderT)((Object)this);
        }

        public BuilderT queryParam(String name, Object value) {
            this.putQueryParameter(name, value);
            return (BuilderT)((Object)this);
        }
    }
}

