package com.aliyun.httpcomponent.httpclient.implementation;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.utils.BaseUtils;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.Header;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ApacheAsyncHttpResponse extends ApacheHttpResponseBase {
    private SimpleHttpResponse apacheResponse;

    public ApacheAsyncHttpResponse(HttpRequest httpRequest, SimpleHttpResponse apacheResponse) {
        super(httpRequest, apacheResponse.getCode(), toHeaders(apacheResponse));
        this.apacheResponse = apacheResponse;
    }

    @Override
    public ByteBuffer getBody() {
        return ByteBuffer.wrap(getBodyAsByteArray());
    }

    @Override
    public byte[] getBodyAsByteArray() {
        return apacheResponse.getBody().getBodyBytes();
    }

    @Override
    public String getBodyAsString() {
        return BaseUtils.bomAwareToString(getBodyAsByteArray(), getHeaderValue("Content-Type"));

    }

    @Override
    public String getBodyAsString(Charset charset) {
        return new String(getBodyAsByteArray(), charset);
    }

    private static HttpHeaders toHeaders(SimpleHttpResponse response) {
        final HttpHeaders httpHeaders = new HttpHeaders();
        Set<String> nameSet = new HashSet<>();
        Header[] apacheHeaders = response.getHeaders();
        for (Header header : apacheHeaders) {
            nameSet.add(header.getName());
        }
        nameSet.forEach((name) -> {
            Header[] entityHeaders = response.getHeaders(name);
            List<String> values = new ArrayList<>();
            for (Header entityHeader : entityHeaders) {
                values.add(entityHeader.getValue());
            }
            httpHeaders.set(name, values);
        });
        return httpHeaders;
    }
}
